/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.dependencies.hikari.pool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import net.tylermurphy.dependencies.hikari.pool.HikariProxyCallableStatement;
import net.tylermurphy.dependencies.hikari.pool.HikariProxyConnection;
import net.tylermurphy.dependencies.hikari.pool.HikariProxyDatabaseMetaData;
import net.tylermurphy.dependencies.hikari.pool.HikariProxyPreparedStatement;
import net.tylermurphy.dependencies.hikari.pool.HikariProxyResultSet;
import net.tylermurphy.dependencies.hikari.pool.HikariProxyStatement;
import net.tylermurphy.dependencies.hikari.pool.PoolEntry;
import net.tylermurphy.dependencies.hikari.pool.ProxyConnection;
import net.tylermurphy.dependencies.hikari.pool.ProxyLeakTask;
import net.tylermurphy.dependencies.hikari.pool.ProxyStatement;
import net.tylermurphy.dependencies.hikari.util.FastList;

public final class ProxyFactory {
    private ProxyFactory() {
    }

    static ProxyConnection getProxyConnection(PoolEntry poolEntry, Connection connection, FastList<Statement> fastList, ProxyLeakTask proxyLeakTask, long l, boolean bl, boolean bl2) {
        return new HikariProxyConnection(poolEntry, connection, (FastList)fastList, proxyLeakTask, l, bl, bl2);
    }

    static Statement getProxyStatement(ProxyConnection proxyConnection, Statement statement) {
        return new HikariProxyStatement(proxyConnection, statement);
    }

    static CallableStatement getProxyCallableStatement(ProxyConnection proxyConnection, CallableStatement callableStatement) {
        return new HikariProxyCallableStatement(proxyConnection, callableStatement);
    }

    static PreparedStatement getProxyPreparedStatement(ProxyConnection proxyConnection, PreparedStatement preparedStatement) {
        return new HikariProxyPreparedStatement(proxyConnection, preparedStatement);
    }

    static ResultSet getProxyResultSet(ProxyConnection proxyConnection, ProxyStatement proxyStatement, ResultSet resultSet) {
        return new HikariProxyResultSet(proxyConnection, proxyStatement, resultSet);
    }

    static DatabaseMetaData getProxyDatabaseMetaData(ProxyConnection proxyConnection, DatabaseMetaData databaseMetaData) {
        return new HikariProxyDatabaseMetaData(proxyConnection, databaseMetaData);
    }
}

