/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.util;

import java.io.File;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.world.VoidGenerator;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;

public class Location {
    private final String world;
    private final double x;
    private final double y;
    private final double z;

    public static Location getDefault() {
        return new Location("", 0.0, 0.0, 0.0);
    }

    public static Location from(Player player) {
        org.bukkit.Location location = player.getLocation();
        return new Location(player.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public Location(@NotNull String world, double x, double y, double z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(@NotNull String world, @NotNull org.bukkit.Location location) {
        this.world = world;
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
    }

    public World load(WorldType type, World.Environment environment) {
        boolean mapSave = this.world.startsWith("hs_");
        World bukkitWorld = Bukkit.getWorld((String)this.world);
        if (bukkitWorld != null) {
            return bukkitWorld;
        }
        WorldCreator creator = new WorldCreator(this.world);
        if (type != null) {
            creator.type(type);
        }
        if (environment != null) {
            creator.environment(environment);
        }
        if (mapSave) {
            creator.generator((ChunkGenerator)new VoidGenerator());
        }
        Bukkit.getServer().createWorld(creator).setAutoSave(!mapSave);
        return Bukkit.getWorld((String)this.world);
    }

    public World load() {
        if (!this.exists()) {
            return null;
        }
        if (!Main.getInstance().isLoaded()) {
            return null;
        }
        return this.load(null, null);
    }

    private org.bukkit.Location toBukkit() {
        return new org.bukkit.Location(Bukkit.getWorld((String)this.world), this.x, this.y, this.z);
    }

    public void teleport(Player player) {
        if (!this.exists()) {
            return;
        }
        if (this.load() == null) {
            return;
        }
        if (Config.spawnPatch) {
            Main.getInstance().scheduleTask(() -> player.teleport(this.toBukkit()));
        } else {
            player.teleport(this.toBukkit());
        }
    }

    public Location changeWorld(String world) {
        return new Location(world, this.x, this.y, this.z);
    }

    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockX() {
        return (int)this.x;
    }

    public int getBlockY() {
        return (int)this.y;
    }

    public int getBlockZ() {
        return (int)this.z;
    }

    public boolean exists() {
        if (this.world.equals("")) {
            return false;
        }
        String path = Main.getInstance().getWorldContainer() + File.separator + this.world;
        File destination = new File(path);
        return destination.isDirectory();
    }

    public boolean isNotSetup() {
        return this.getBlockX() == 0 && this.getBlockY() == 0 && this.getBlockZ() == 0;
    }

    public boolean isNotInBounds(int xmin, int xmax, int zmin, int zmax) {
        return this.getBlockX() <= xmin || this.getBlockX() >= xmax || this.getBlockZ() <= zmin || this.getBlockZ() >= zmax;
    }
}

