/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game.listener;

import java.util.ArrayList;
import java.util.List;
import net.tylermurphy.dependencies.xseries.XMaterial;
import net.tylermurphy.dependencies.xseries.messages.ActionBar;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class InteractHandler
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!Main.getInstance().getBoard().contains(event.getPlayer())) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && Config.blockedInteracts.contains(event.getClickedBlock().getType().name())) {
            event.setCancelled(true);
            return;
        }
        ItemStack temp = event.getItem();
        if (temp == null) {
            return;
        }
        if (Main.getInstance().getGame().getStatus() == Status.STANDBY) {
            this.onPlayerInteractLobby(temp, event);
        }
        if (Main.getInstance().getGame().getStatus() == Status.PLAYING) {
            this.onPlayerInteractGame(temp, event);
        }
        if (Main.getInstance().getBoard().isSpectator(event.getPlayer())) {
            this.onSpectatorInteract(temp, event);
        }
    }

    private void onPlayerInteractLobby(ItemStack temp, PlayerInteractEvent event) {
        if (temp.isSimilar(Config.lobbyLeaveItem)) {
            event.setCancelled(true);
            Main.getInstance().getGame().leave(event.getPlayer());
        }
        if (temp.isSimilar(Config.lobbyStartItem) && event.getPlayer().hasPermission("hideandseek.start")) {
            event.setCancelled(true);
            if (Main.getInstance().getGame().checkCurrentMap()) {
                event.getPlayer().sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
                return;
            }
            if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
                event.getPlayer().sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
                return;
            }
            if (Main.getInstance().getBoard().size() < Config.minPlayers) {
                event.getPlayer().sendMessage(Config.errorPrefix + Localization.message("START_MIN_PLAYERS").addAmount(Config.minPlayers));
                return;
            }
            Main.getInstance().getGame().start();
        }
    }

    private void onPlayerInteractGame(ItemStack temp, PlayerInteractEvent event) {
        if (temp.isSimilar(Config.glowPowerupItem)) {
            if (!Config.glowEnabled) {
                return;
            }
            Player player = event.getPlayer();
            if (Main.getInstance().getBoard().isHider(player)) {
                Main.getInstance().getGame().getGlow().onProjectile();
                player.getInventory().remove(Config.glowPowerupItem);
                assert (XMaterial.SNOWBALL.parseMaterial() != null);
                player.getInventory().remove(XMaterial.SNOWBALL.parseMaterial());
                event.setCancelled(true);
            }
        }
    }

    private void onSpectatorInteract(ItemStack temp, PlayerInteractEvent event) {
        if (temp.isSimilar(Config.flightToggleItem)) {
            boolean isFlying = event.getPlayer().getAllowFlight();
            event.getPlayer().setAllowFlight(!isFlying);
            event.getPlayer().setFlying(!isFlying);
            ActionBar.clearActionBar(event.getPlayer());
            if (!isFlying) {
                ActionBar.sendActionBar(event.getPlayer(), Localization.message("FLYING_ENABLED").toString());
            } else {
                ActionBar.sendActionBar(event.getPlayer(), Localization.message("FLYING_DISABLED").toString());
            }
            return;
        }
        if (temp.isSimilar(Config.teleportItem)) {
            int amount = Main.getInstance().getBoard().getHiders().size() + Main.getInstance().getBoard().getSeekers().size();
            Inventory teleportMenu = Main.getInstance().getServer().createInventory(null, 9 * ((amount - 1) / 9 + 1), ChatColor.stripColor((String)Config.teleportItem.getItemMeta().getDisplayName()));
            ArrayList<String> hider_lore = new ArrayList<String>();
            hider_lore.add(Localization.message("HIDER_TEAM_NAME").toString());
            Main.getInstance().getBoard().getHiders().forEach(hider -> teleportMenu.addItem(new ItemStack[]{this.getSkull((Player)hider, (List<String>)hider_lore)}));
            ArrayList<String> seeker_lore = new ArrayList<String>();
            seeker_lore.add(Localization.message("SEEKER_TEAM_NAME").toString());
            Main.getInstance().getBoard().getSeekers().forEach(seeker -> teleportMenu.addItem(new ItemStack[]{this.getSkull((Player)seeker, (List<String>)seeker_lore)}));
            event.getPlayer().openInventory(teleportMenu);
        }
    }

    private ItemStack getSkull(Player player, List<String> lore) {
        assert (XMaterial.PLAYER_HEAD.parseMaterial() != null);
        ItemStack playerHead = new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial(), 1, 3);
        SkullMeta playerHeadMeta = (SkullMeta)playerHead.getItemMeta();
        playerHeadMeta.setOwner(player.getName());
        playerHeadMeta.setDisplayName(player.getName());
        playerHeadMeta.setLore(lore);
        playerHead.setItemMeta((ItemMeta)playerHeadMeta);
        return playerHead;
    }
}

