/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.database;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.database.GameDataTable;
import net.tylermurphy.hideAndSeek.database.InventoryTable;
import net.tylermurphy.hideAndSeek.database.LegacyTable;
import net.tylermurphy.hideAndSeek.database.NameDataTable;
import net.tylermurphy.hideAndSeek.database.connections.DatabaseConnection;
import net.tylermurphy.hideAndSeek.database.connections.MySQLConnection;
import net.tylermurphy.hideAndSeek.database.connections.SQLiteConnection;

public class Database {
    private final GameDataTable playerInfo;
    private final NameDataTable nameInfo;
    private final InventoryTable inventoryInfo;
    private final DatabaseConnection connection;

    public Database() {
        if (Config.databaseType.equalsIgnoreCase("SQLITE")) {
            Main.getInstance().getLogger().info("SQLITE database chosen");
            this.connection = new SQLiteConnection();
        } else if (Config.databaseType.equalsIgnoreCase("MYSQL")) {
            Main.getInstance().getLogger().info("MYSQL database chosen");
            this.connection = new MySQLConnection();
        } else {
            throw new IllegalArgumentException("Invalid database type: " + Config.databaseType);
        }
        this.playerInfo = new GameDataTable(this);
        this.nameInfo = new NameDataTable(this);
        this.inventoryInfo = new InventoryTable(this);
        LegacyTable legacyTable = new LegacyTable(this);
        if (legacyTable.exists() && legacyTable.copyData() && !legacyTable.drop()) {
            Main.getInstance().getLogger().severe("Failed to drop old legacy table: player_info. Some data may be duplicated!");
        }
    }

    public GameDataTable getGameData() {
        return this.playerInfo;
    }

    public NameDataTable getNameData() {
        return this.nameInfo;
    }

    public InventoryTable getInventoryData() {
        return this.inventoryInfo;
    }

    protected Connection connect() {
        Connection conn = null;
        try {
            conn = this.connection.connect();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe(e.getMessage());
            e.printStackTrace();
        }
        return conn;
    }

    protected byte[] encodeUUID(UUID uuid) {
        try {
            byte[] bytes = new byte[16];
            ByteBuffer.wrap(bytes).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            byte[] result = new byte[((InputStream)is).available()];
            if (is.read(result) == -1) {
                Main.getInstance().getLogger().severe("IO Error: Failed to read bytes from input stream");
                return new byte[0];
            }
            return result;
        }
        catch (IOException e) {
            Main.getInstance().getLogger().severe("IO Error: " + e.getMessage());
            return new byte[0];
        }
    }

    protected UUID decodeUUID(byte[] bytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        try {
            buffer.put(ByteStreams.toByteArray((InputStream)is));
            buffer.flip();
            return new UUID(buffer.getLong(), buffer.getLong());
        }
        catch (IOException e) {
            Main.getInstance().getLogger().severe("IO Error: " + e.getMessage());
            return null;
        }
    }
}

