/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.ConfigManager;
import net.tylermurphy.hideAndSeek.configuration.LocalizationString;

public class Localization {
    public static final Map<String, LocalizationString> LOCAL = new HashMap<String, LocalizationString>();
    public static final Map<String, LocalizationString> DEFAULT_LOCAL = new HashMap<String, LocalizationString>();
    private static final Map<String, String[][]> CHANGES = new HashMap<String, String[][]>(){
        {
            this.put("en-US", new String[][]{{"WORLDBORDER_DECREASING"}, {"START", "TAUNTED"}, {"GAME_SETUP", "SETUP_GAME", "SETUP_LOBBY", "SETUP_SEEKER_LOBBY", "SETUP_EXIT", "SETUP_SAVEMAP", "SETUP_BOUNDS"}});
            this.put("de-DE", new String[][]{new String[0], {"TAUNTED"}, {"GAME_SETUP", "SETUP_GAME", "SETUP_LOBBY", "SETUP_SEEKER_LOBBY", "SETUP_EXIT", "SETUP_SAVEMAP", "SETUP_BOUNDS"}});
        }
    };

    public static void loadLocalization() {
        String SELECTED_LOCAL;
        ConfigManager manager = ConfigManager.create("localization.yml", "lang/localization_" + Config.locale + ".yml");
        int PLUGIN_VERSION = manager.getDefaultInt("version");
        int VERSION = manager.getInt("version");
        if (VERSION < PLUGIN_VERSION) {
            for (int i = VERSION; i < PLUGIN_VERSION; ++i) {
                String[] changeList;
                if (i < 1) continue;
                for (String change : changeList = CHANGES.get(Config.locale)[i - 1]) {
                    manager.reset("Localization." + change);
                }
            }
            manager.reset("version");
        }
        if ((SELECTED_LOCAL = manager.getString("type")) == null) {
            manager.reset("type");
        } else if (!SELECTED_LOCAL.equals(Config.locale)) {
            manager.resetFile("lang" + File.separator + "localization_" + Config.locale + ".yml");
        }
        manager.saveConfig();
        for (String key : manager.getConfigurationSection("Localization").getKeys(false)) {
            LOCAL.put(key, new LocalizationString(ChatColor.translateAlternateColorCodes((char)'&', (String)manager.getString("Localization." + key))));
        }
        for (String key : manager.getDefaultConfigurationSection("Localization").getKeys(false)) {
            DEFAULT_LOCAL.put(key, new LocalizationString(ChatColor.translateAlternateColorCodes((char)'&', (String)manager.getString("Localization." + key))));
        }
    }

    public static LocalizationString message(String key) {
        LocalizationString message = LOCAL.get(key);
        if (message == null) {
            LocalizationString defaultMessage = DEFAULT_LOCAL.get(key);
            if (defaultMessage == null) {
                return new LocalizationString(ChatColor.RED + "" + ChatColor.ITALIC + key + " is not found in localization.yml. This is a plugin issue, please report it.");
            }
            return new LocalizationString(defaultMessage.toString());
        }
        return new LocalizationString(message.toString());
    }
}

