/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.world;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Create
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        World.Environment environment;
        WorldType type;
        List<String> worlds = Main.getInstance().getWorlds();
        if (worlds.contains(args[0])) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLD_EXISTS").addAmount(args[0]));
            return;
        }
        switch (args[1]) {
            case "normal": {
                type = WorldType.NORMAL;
                environment = World.Environment.NORMAL;
                break;
            }
            case "flat": {
                type = WorldType.FLAT;
                environment = World.Environment.NORMAL;
                break;
            }
            case "nether": {
                type = WorldType.NORMAL;
                environment = World.Environment.NETHER;
                break;
            }
            case "end": {
                type = WorldType.NORMAL;
                environment = World.Environment.THE_END;
                break;
            }
            default: {
                sender.sendMessage(Config.errorPrefix + Localization.message("INVALID_WORLD_TYPE").addAmount(args[1]));
                return;
            }
        }
        Location temp = new Location(args[0], 0.0, 0.0, 0.0);
        if (temp.load(type, environment) == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLD_ADDED_FAILED"));
        } else {
            sender.sendMessage(Config.messagePrefix + Localization.message("WORLD_ADDED").addAmount(args[0]));
        }
    }

    @Override
    public String getLabel() {
        return "create";
    }

    @Override
    public String getUsage() {
        return "<name> <type>";
    }

    @Override
    public String getDescription() {
        return "Create a new world";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("name")) {
            return Collections.singletonList("name");
        }
        if (parameter.equals("type")) {
            return Arrays.asList("normal", "flat", "nether", "end");
        }
        return null;
    }
}

