/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.command.map.Save;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Pair;
import net.tylermurphy.hideAndSeek.util.Tuple;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class CommandGroup {
    private final Map<String, Object> commandRegister;
    private final String label;

    public CommandGroup(String label, Object ... data) {
        this.label = label;
        this.commandRegister = new LinkedHashMap<String, Object>();
        for (Object o : data) {
            this.registerCommand(o);
        }
    }

    public String getLabel() {
        return this.label;
    }

    private void registerCommand(Object object) {
        CommandGroup group;
        if (object instanceof ICommand) {
            ICommand command = (ICommand)object;
            if (!this.commandRegister.containsKey(command.getLabel())) {
                this.commandRegister.put(command.getLabel().toLowerCase(), command);
            }
        } else if (object instanceof CommandGroup && !this.commandRegister.containsKey((group = (CommandGroup)object).getLabel())) {
            this.commandRegister.put(group.getLabel().toLowerCase(), group);
        }
    }

    public void handleCommand(Player player, String[] args) {
        Tuple<ICommand, String, String[]> data = this.getCommand(args, this.getLabel());
        if (data == null) {
            player.sendMessage(String.format("%s%sKenshin's Hide and Seek %s(%s1.7.1%s)\n", ChatColor.AQUA, ChatColor.BOLD, ChatColor.GRAY, ChatColor.WHITE, ChatColor.GRAY) + String.format("%sAuthor: %s[KenshinEto]\n", ChatColor.GRAY, ChatColor.WHITE) + String.format("%sHelp Command: %s/hs %shelp", ChatColor.GRAY, ChatColor.AQUA, ChatColor.WHITE));
            return;
        }
        ICommand command = data.getLeft();
        String permission = data.getCenter();
        String[] parameters = data.getRight();
        if (Save.runningBackup) {
            player.sendMessage(Config.errorPrefix + Localization.message("MAPSAVE_INPROGRESS"));
            return;
        }
        if (Config.permissionsRequired && !player.hasPermission(permission)) {
            player.sendMessage(Config.errorPrefix + Localization.message("COMMAND_NOT_ALLOWED"));
            return;
        }
        int parameterCount = (int)Arrays.stream(command.getUsage().split(" ")).filter(p -> p.startsWith("<") && !p.startsWith("<*")).count();
        if (parameters.length < parameterCount) {
            player.sendMessage(Config.errorPrefix + Localization.message("ARGUMENT_COUNT"));
            return;
        }
        try {
            command.execute(player, parameters);
        }
        catch (Exception e) {
            player.sendMessage(Config.errorPrefix + "An error has occurred.");
            e.printStackTrace();
        }
    }

    @Nullable
    private Tuple<ICommand, String, String[]> getCommand(String[] args, String permission) {
        if (args.length < 1) {
            return null;
        }
        String invoke = args[0];
        if (this.commandRegister.containsKey(invoke)) {
            Object o = this.commandRegister.get(invoke);
            if (o instanceof CommandGroup) {
                CommandGroup group = (CommandGroup)o;
                return group.getCommand(Arrays.copyOfRange(args, 1, args.length), permission + "." + group.getLabel());
            }
            if (o instanceof ICommand) {
                ICommand command = (ICommand)o;
                return new Tuple<ICommand, String, String[]>(command, permission + "." + command.getLabel(), Arrays.copyOfRange(args, 1, args.length));
            }
        }
        return null;
    }

    public List<String> handleTabComplete(Player player, String[] args) {
        return this.handleTabComplete(player, this.getLabel(), args);
    }

    private List<String> handleTabComplete(Player player, String permission, String[] args) {
        String invoke = args[0].toLowerCase();
        if (args.length == 1) {
            return new ArrayList<String>(this.commandRegister.keySet()).stream().filter(handle -> handle.toLowerCase().startsWith(invoke)).filter(handle -> {
                Object object = this.commandRegister.get(handle);
                if (object instanceof ICommand) {
                    ICommand command = (ICommand)object;
                    return !Config.permissionsRequired || player.hasPermission(permission + "." + command.getLabel());
                }
                if (object instanceof CommandGroup) {
                    CommandGroup group = (CommandGroup)object;
                    return !Config.permissionsRequired || group.hasPermission(player, permission + "." + group.getLabel());
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (this.commandRegister.containsKey(invoke)) {
            String parameter;
            String name;
            List<String> list;
            ICommand command;
            String[] usage;
            Object object = this.commandRegister.get(invoke);
            if (object instanceof CommandGroup) {
                CommandGroup group = (CommandGroup)object;
                return group.handleTabComplete(player, permission + "." + group.getLabel(), Arrays.copyOfRange(args, 1, args.length));
            }
            if (object instanceof ICommand && args.length - 2 < (usage = (command = (ICommand)object).getUsage().split(" ")).length && (list = command.autoComplete(name = (parameter = usage[args.length - 2]).replace("<", "").replace(">", ""), args[args.length - 1])) != null) {
                return list;
            }
        }
        return new ArrayList<String>();
    }

    private boolean hasPermission(Player player, String permission) {
        for (Object object : this.commandRegister.values()) {
            CommandGroup group;
            if (object instanceof ICommand) {
                ICommand command = (ICommand)object;
                if (!player.hasPermission(permission + command.getLabel())) continue;
                return true;
            }
            if (!(object instanceof CommandGroup) || !(group = (CommandGroup)object).hasPermission(player, permission + this.label + ".")) continue;
            return true;
        }
        return false;
    }

    public List<Pair<String, ICommand>> getCommands() {
        return this.getCommands(this.getLabel());
    }

    private List<Pair<String, ICommand>> getCommands(String prefix) {
        LinkedList<Pair<String, ICommand>> commands = new LinkedList<Pair<String, ICommand>>();
        for (Object object : this.commandRegister.values()) {
            if (object instanceof ICommand) {
                ICommand command = (ICommand)object;
                commands.add(new Pair<String, ICommand>(prefix + " " + command.getLabel(), command));
                continue;
            }
            if (!(object instanceof CommandGroup)) continue;
            CommandGroup group = (CommandGroup)object;
            commands.addAll(group.getCommands(prefix + " " + group.getLabel()));
        }
        return commands;
    }
}

