/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.map.set;

import java.util.List;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.command.location.LocationUtils;
import net.tylermurphy.hideAndSeek.command.location.Locations;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.util.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SeekerLobby
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        LocationUtils.setLocation(sender, Locations.SEEKER, args[0], map -> {
            if (map.getSpawn().isNotSetup()) {
                throw new RuntimeException(Localization.message("GAME_SPAWN_NEEDED").toString());
            }
            if (!map.getSpawnName().equals(sender.getLocation().getWorld().getName())) {
                throw new RuntimeException(Localization.message("SEEKER_LOBBY_INVALID").toString());
            }
            map.setSeekerLobby(Location.from(sender));
            if (!map.isBoundsNotSetup()) {
                Vector boundsMin = map.getBoundsMin();
                Vector boundsMax = map.getBoundsMax();
                if (map.getSeekerLobby().isNotInBounds(boundsMin.getBlockX(), boundsMax.getBlockX(), boundsMin.getBlockZ(), boundsMax.getBlockZ())) {
                    sender.sendMessage(Config.warningPrefix + Localization.message("WARN_MAP_BOUNDS"));
                }
            }
        });
    }

    @Override
    public String getLabel() {
        return "seekerlobby";
    }

    @Override
    public String getUsage() {
        return "<map>";
    }

    @Override
    public String getDescription() {
        return "Sets the maps seeker lobby location";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("map")) {
            return Maps.getAllMaps().stream().map(Map::getName).collect(Collectors.toList());
        }
        return null;
    }
}

