/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.map;

import java.util.List;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Remove
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        Map map = Maps.getMap(args[0]);
        if (map == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("INVALID_MAP"));
        } else if (!Maps.removeMap(args[0])) {
            sender.sendMessage(Config.errorPrefix + Localization.message("MAP_FAIL_DELETE").addAmount(args[0]));
        } else {
            sender.sendMessage(Config.messagePrefix + Localization.message("MAP_DELETED").addAmount(args[0]));
        }
    }

    @Override
    public String getLabel() {
        return "remove";
    }

    @Override
    public String getUsage() {
        return "<map>";
    }

    @Override
    public String getDescription() {
        return "Remove a map from the plugin!";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("map")) {
            return Maps.getAllMaps().stream().map(Map::getName).collect(Collectors.toList());
        }
        return null;
    }
}

