/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.location;

import java.util.function.Consumer;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.location.Locations;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LocationUtils {
    public static void setLocation(@NotNull Player player, @NotNull Locations place, String mapName, @NotNull Consumer<Map> consumer) {
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            player.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        if (player.getLocation().getBlockX() == 0 || player.getLocation().getBlockZ() == 0 || player.getLocation().getBlockY() == 0) {
            player.sendMessage(Config.errorPrefix + Localization.message("NOT_AT_ZERO"));
            return;
        }
        Map map = null;
        if (mapName != null && (map = Maps.getMap(mapName)) == null) {
            player.sendMessage(Config.errorPrefix + Localization.message("INVALID_MAP"));
            return;
        }
        try {
            consumer.accept(map);
        }
        catch (Exception e) {
            player.sendMessage(Config.errorPrefix + e.getMessage());
            return;
        }
        if (map != null) {
            Maps.setMap(mapName, map);
        }
        player.sendMessage(Config.messagePrefix + Localization.message(place.message()));
    }
}

