/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.database.util.PlayerInfo;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Wins
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        Main.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
            String name;
            UUID uuid;
            if (args.length == 0) {
                uuid = sender.getUniqueId();
                name = sender.getName();
            } else {
                name = args[0];
                uuid = Main.getInstance().getDatabase().getNameData().getUUID(args[0]);
            }
            if (uuid == null) {
                sender.sendMessage(Config.errorPrefix + Localization.message("START_INVALID_NAME").addPlayer(args[0]));
                return;
            }
            PlayerInfo info = Main.getInstance().getDatabase().getGameData().getInfo(uuid);
            if (info == null) {
                sender.sendMessage(Config.errorPrefix + Localization.message("NO_GAME_INFO"));
                return;
            }
            String message = ChatColor.WHITE + "" + ChatColor.BOLD + "==============================\n";
            message = message + Localization.message("INFORMATION_FOR").addPlayer(name) + "\n";
            message = message + "==============================\n";
            message = message + String.format("%sTOTAL WINS: %s%s\n%sHIDER WINS: %s%s\n%sSEEKER WINS: %s%s\n%sGAMES PLAYED: %s", ChatColor.YELLOW, ChatColor.WHITE, info.getSeekerWins() + info.getHiderWins(), ChatColor.GOLD, ChatColor.WHITE, info.getHiderWins(), ChatColor.RED, ChatColor.WHITE, info.getSeekerWins(), ChatColor.WHITE, info.getSeekerGames() + info.getHiderGames());
            message = message + ChatColor.WHITE + "" + ChatColor.BOLD + "\n==============================";
            sender.sendMessage(message);
        });
    }

    @Override
    public String getLabel() {
        return "wins";
    }

    @Override
    public String getUsage() {
        return "<*player>";
    }

    @Override
    public String getDescription() {
        return "Get the win information for yourself or another player.";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return Collections.singletonList(parameter);
    }
}

