/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.world;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.world.VoidGenerator;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;

public class WorldLoader {
    private final Map map;

    public WorldLoader(Map map) {
        this.map = map;
    }

    public World getWorld() {
        return Bukkit.getServer().getWorld(this.map.getGameSpawnName());
    }

    public void unloadMap() {
        World world = Bukkit.getServer().getWorld(this.map.getGameSpawnName());
        if (world == null) {
            Main.getInstance().getLogger().warning(this.map.getGameSpawnName() + " already unloaded.");
            return;
        }
        world.getPlayers().forEach(player -> Config.exitPosition.teleport((Player)player));
        Main.getInstance().scheduleTask(() -> {
            if (Bukkit.getServer().unloadWorld(world, false)) {
                Main.getInstance().getLogger().info("Successfully unloaded " + this.map.getGameSpawnName());
            } else {
                Main.getInstance().getLogger().severe("COULD NOT UNLOAD " + this.map.getGameSpawnName());
            }
        });
    }

    public void loadMap() {
        Main.getInstance().scheduleTask(() -> {
            Bukkit.getServer().createWorld(new WorldCreator(this.map.getGameSpawnName()).generator((ChunkGenerator)new VoidGenerator()));
            World world = Bukkit.getServer().getWorld(this.map.getGameSpawnName());
            if (world == null) {
                Main.getInstance().getLogger().severe("COULD NOT LOAD " + this.map.getGameSpawnName());
                return;
            }
            world.setAutoSave(false);
        });
    }

    public void rollback() {
        this.unloadMap();
        this.loadMap();
    }

    public String save() {
        World world = Bukkit.getServer().getWorld(this.map.getSpawnName());
        if (world == null) {
            return Config.errorPrefix + Localization.message("MAPSAVE_INVALID").addAmount(this.map.getSpawnName());
        }
        File current = new File(Main.getInstance().getWorldContainer() + File.separator + this.map.getSpawnName());
        if (current.exists()) {
            try {
                File destination = new File(Main.getInstance().getWorldContainer() + File.separator + this.map.getGameSpawnName());
                File temp_destination = new File(Main.getInstance().getWorldContainer() + File.separator + "temp_" + this.map.getGameSpawnName());
                this.copyFileFolder("region", true);
                this.copyFileFolder("entities", true);
                this.copyFileFolder("datapacks", false);
                this.copyFileFolder("data", false);
                File srcFile = new File(current, "level.dat");
                File destFile = new File(temp_destination, "level.dat");
                this.copyFile(srcFile, destFile);
                if (destination.exists()) {
                    WorldLoader.deleteDirectory(destination);
                }
                if (!temp_destination.renameTo(destination)) {
                    return Config.errorPrefix + Localization.message("MAPSAVE_FAIL_DIR").addAmount(temp_destination.getPath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return Config.errorPrefix + Localization.message("COMMAND_ERROR");
            }
            return Config.messagePrefix + Localization.message("MAPSAVE_END");
        }
        return Config.errorPrefix + Localization.message("MAPSAVE_ERROR");
    }

    private void copyFileFolder(String name, Boolean isMca) throws IOException {
        File region = new File(Main.getInstance().getWorldContainer() + File.separator + this.map.getSpawnName() + File.separator + name);
        File temp = new File(Main.getInstance().getWorldContainer() + File.separator + "temp_" + this.map.getGameSpawnName() + File.separator + name);
        if (region.exists() && region.isDirectory()) {
            if (!temp.exists() && !temp.mkdirs()) {
                throw new IOException("Couldn't create region directory!");
            }
            String[] files = region.list();
            if (files == null) {
                Main.getInstance().getLogger().severe("Region directory is null or cannot be accessed");
                return;
            }
            for (String file : files) {
                File srcFile;
                if (isMca.booleanValue()) {
                    int minX = (int)Math.floor(this.map.getBoundsMin().getX() / 512.0);
                    int minZ = (int)Math.floor(this.map.getBoundsMin().getZ() / 512.0);
                    int maxX = (int)Math.floor(this.map.getBoundsMax().getX() / 512.0);
                    int maxZ = (int)Math.floor(this.map.getBoundsMax().getZ() / 512.0);
                    String[] parts = file.split("\\.");
                    if (parts.length > 1) {
                        Main.getInstance().getLogger().info(file);
                        if (Integer.parseInt(parts[1]) < minX || Integer.parseInt(parts[1]) > maxX || Integer.parseInt(parts[2]) < minZ || Integer.parseInt(parts[2]) > maxZ) continue;
                    }
                }
                if ((srcFile = new File(region, file)).isDirectory()) {
                    this.copyFileFolder(name + File.separator + file, false);
                    continue;
                }
                File destFile = new File(temp, file);
                this.copyFile(srcFile, destFile);
            }
        }
    }

    private void copyFile(File source, File target) throws IOException {
        int length;
        InputStream in = Files.newInputStream(source.toPath(), new OpenOption[0]);
        OutputStream out = Files.newOutputStream(target.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            out.write(buffer, 0, length);
        }
        in.close();
        out.close();
    }

    public static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                WorldLoader.deleteDirectory(file);
            }
        }
        if (!directoryToBeDeleted.delete()) {
            throw new RuntimeException("Failed to delete directory: " + directoryToBeDeleted.getPath());
        }
    }
}

