/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.tylermurphy.dependencies.xseries.messages.ActionBar;
import net.tylermurphy.dependencies.xseries.messages.Titles;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.PlayerLoader;
import net.tylermurphy.hideAndSeek.game.events.Glow;
import net.tylermurphy.hideAndSeek.game.events.Taunt;
import net.tylermurphy.hideAndSeek.game.listener.RespawnHandler;
import net.tylermurphy.hideAndSeek.game.util.CountdownDisplay;
import net.tylermurphy.hideAndSeek.game.util.Status;
import net.tylermurphy.hideAndSeek.game.util.WinType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Game {
    private final Taunt taunt;
    private final Glow glow;
    private final Board board;
    private Status status;
    private Map currentMap;
    private int gameTick;
    private int lobbyTimer;
    private int startingTimer;
    private int gameTimer;
    private boolean hiderLeft;

    public Game(Map map, Board board) {
        this.currentMap = map;
        this.taunt = new Taunt();
        this.glow = new Glow();
        this.status = Status.STANDBY;
        this.board = board;
        this.gameTick = 0;
        this.lobbyTimer = -1;
        this.startingTimer = -1;
        this.gameTimer = 0;
        this.hiderLeft = false;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getTimeLeft() {
        return this.gameTimer;
    }

    public int getLobbyTime() {
        return this.lobbyTimer;
    }

    public Glow getGlow() {
        return this.glow;
    }

    public Taunt getTaunt() {
        return this.taunt;
    }

    public void start() {
        Player seeker;
        try {
            int rand = (int)(Math.random() * (double)this.board.getPlayers().size());
            seeker = this.board.getPlayers().get(rand);
        }
        catch (Exception e) {
            Main.getInstance().getLogger().warning("Failed to select random seeker.");
            return;
        }
        this.start(seeker);
    }

    public void start(Player seeker) {
        if (Config.mapSaveEnabled) {
            this.currentMap.getWorldLoader().rollback();
        }
        this.board.reload();
        this.board.addSeeker(seeker);
        PlayerLoader.loadSeeker(seeker, this.currentMap);
        this.board.getPlayers().forEach(player -> {
            if (this.board.isSeeker((Player)player)) {
                return;
            }
            this.board.addHider((Player)player);
            PlayerLoader.loadHider(player, this.currentMap);
        });
        this.board.getPlayers().forEach(this.board::createGameBoard);
        this.currentMap.getWorldBorder().resetWorldBorder();
        if (Config.gameLength > 0) {
            this.gameTimer = Config.gameLength;
        }
        this.status = Status.STARTING;
        this.startingTimer = 30;
    }

    private void stop(WinType type) {
        this.status = Status.ENDING;
        List<UUID> players = this.board.getPlayers().stream().map(Entity::getUniqueId).collect(Collectors.toList());
        if (type == WinType.HIDER_WIN) {
            List<UUID> winners = this.board.getHiders().stream().map(Entity::getUniqueId).collect(Collectors.toList());
            Main.getInstance().getDatabase().getGameData().addWins(this.board, players, winners, this.board.getHiderKills(), this.board.getHiderDeaths(), this.board.getSeekerKills(), this.board.getSeekerDeaths(), type);
        } else if (type == WinType.SEEKER_WIN) {
            ArrayList<UUID> winners = new ArrayList<UUID>();
            winners.add(this.board.getFirstSeeker().getUniqueId());
            Main.getInstance().getDatabase().getGameData().addWins(this.board, players, winners, this.board.getHiderKills(), this.board.getHiderDeaths(), this.board.getSeekerKills(), this.board.getSeekerDeaths(), type);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), this::end, 100L);
    }

    public void end() {
        this.board.getPlayers().forEach(PlayerLoader::unloadPlayer);
        this.currentMap.getWorldBorder().resetWorldBorder();
        Map nextMap = Maps.getRandomMap();
        if (nextMap != null) {
            this.currentMap = nextMap;
        }
        this.board.getPlayers().forEach(player -> {
            if (Config.leaveOnEnd) {
                this.board.removeBoard((Player)player);
                this.board.remove((Player)player);
                this.handleBungeeLeave((Player)player);
            } else {
                this.currentMap.getLobby().teleport((Player)player);
                this.board.createLobbyBoard((Player)player);
                this.board.addHider((Player)player);
                PlayerLoader.joinPlayer(player, this.currentMap);
            }
        });
        RespawnHandler.temp_loc.clear();
        if (Config.mapSaveEnabled) {
            this.currentMap.getWorldLoader().unloadMap();
        }
        this.board.reloadLobbyBoards();
        this.status = Status.ENDED;
    }

    public void join(Player player) {
        if (this.status != Status.STARTING && this.status != Status.PLAYING) {
            if (Config.saveInventory) {
                ItemStack[] data = player.getInventory().getContents();
                Main.getInstance().getDatabase().getInventoryData().saveInventory(player.getUniqueId(), data);
            }
            PlayerLoader.joinPlayer(player, this.currentMap);
            this.board.addHider(player);
            this.board.createLobbyBoard(player);
            this.board.reloadLobbyBoards();
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.messagePrefix + Localization.message("GAME_JOIN").addPlayer((Entity)player)));
            } else {
                this.broadcastMessage(Config.messagePrefix + Localization.message("GAME_JOIN").addPlayer((Entity)player));
            }
        } else {
            PlayerLoader.loadSpectator(player, this.currentMap);
            this.board.addSpectator(player);
            this.board.createGameBoard(player);
            player.sendMessage(Config.messagePrefix + Localization.message("GAME_JOIN_SPECTATOR"));
        }
    }

    public void leave(Player player) {
        PlayerLoader.unloadPlayer(player);
        if (Config.saveInventory) {
            ItemStack[] data = Main.getInstance().getDatabase().getInventoryData().getInventory(player.getUniqueId());
            player.getInventory().setContents(data);
        }
        if (Config.announceMessagesToNonPlayers) {
            Bukkit.broadcastMessage((String)(Config.messagePrefix + Localization.message("GAME_LEAVE").addPlayer((Entity)player)));
        } else {
            this.broadcastMessage(Config.messagePrefix + Localization.message("GAME_LEAVE").addPlayer((Entity)player));
        }
        if (this.board.isHider(player) && this.status != Status.ENDING && this.status != Status.STANDBY) {
            this.hiderLeft = true;
        }
        this.board.removeBoard(player);
        this.board.remove(player);
        if (this.status == Status.STANDBY) {
            this.board.reloadLobbyBoards();
        } else {
            this.board.reloadGameBoards();
            this.board.reloadBoardTeams();
        }
        this.handleBungeeLeave(player);
    }

    private void handleBungeeLeave(Player player) {
        if (Config.bungeeLeave) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("Connect");
            out.writeUTF(Config.leaveServer);
            player.sendPluginMessage((Plugin)Main.getInstance(), "BungeeCord", out.toByteArray());
        } else {
            Config.exitPosition.teleport(player);
        }
    }

    public void onTick() {
        if (this.currentMap == null || this.currentMap.isNotSetup()) {
            return;
        }
        if (this.status == Status.STANDBY) {
            this.whileWaiting();
        } else if (this.status == Status.STARTING) {
            this.whileStarting();
        } else if (this.status == Status.PLAYING) {
            this.whilePlaying();
        }
        ++this.gameTick;
    }

    private void whileWaiting() {
        if (!Config.lobbyCountdownEnabled) {
            return;
        }
        if (Config.lobbyMin <= this.board.size()) {
            if (this.lobbyTimer < 0) {
                this.lobbyTimer = Config.countdown;
            }
            if (this.board.size() >= Config.changeCountdown) {
                this.lobbyTimer = Math.min(this.lobbyTimer, 10);
            }
            if (this.gameTick % 20 == 0) {
                --this.lobbyTimer;
                this.board.reloadLobbyBoards();
            }
            if (this.lobbyTimer == 0) {
                this.start();
            }
        } else {
            this.lobbyTimer = -1;
        }
    }

    private void whileStarting() {
        if (this.gameTick % 20 == 0) {
            if (this.startingTimer % 5 == 0 || this.startingTimer < 5) {
                String message;
                if (this.startingTimer == 0) {
                    message = Localization.message("START").toString();
                    this.status = Status.PLAYING;
                    this.board.getPlayers().forEach(player -> {
                        PlayerLoader.resetPlayer(player, this.board);
                        if (this.board.isSeeker((Player)player)) {
                            this.currentMap.getGameSpawn().teleport((Player)player);
                        }
                    });
                } else {
                    message = this.startingTimer == 1 ? Localization.message("START_COUNTDOWN_LAST").addAmount(this.startingTimer).toString() : Localization.message("START_COUNTDOWN").addAmount(this.startingTimer).toString();
                }
                this.board.getPlayers().forEach(player -> {
                    if (Config.countdownDisplay == CountdownDisplay.CHAT) {
                        player.sendMessage(Config.messagePrefix + message);
                    } else if (Config.countdownDisplay == CountdownDisplay.ACTIONBAR) {
                        ActionBar.clearActionBar(player);
                        ActionBar.sendActionBar(player, Config.messagePrefix + message);
                    } else if (Config.countdownDisplay == CountdownDisplay.TITLE && this.startingTimer != 30) {
                        Titles.clearTitle(player);
                        Titles.sendTitle(player, 10, 40, 10, " ", message);
                    }
                });
            }
            --this.startingTimer;
        }
        this.checkWinConditions();
    }

    private void whilePlaying() {
        for (Player hider : this.board.getHiders()) {
            int distance = 100;
            int temp = 100;
            for (Player seeker : this.board.getSeekers()) {
                try {
                    temp = (int)hider.getLocation().distance(seeker.getLocation());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (distance <= temp) continue;
                distance = temp;
            }
            if (!Config.seekerPing) continue;
            switch (this.gameTick % 10) {
                case 0: {
                    if (distance < Config.seekerPingLevel1) {
                        Config.heartbeatSound.play((Entity)hider, Config.seekerPingLeadingVolume, Config.seekerPingPitch);
                    }
                    if (distance >= Config.seekerPingLevel3) break;
                    Config.ringingSound.play((Entity)hider, Config.seekerPingVolume, Config.seekerPingPitch);
                    break;
                }
                case 3: {
                    if (distance < Config.seekerPingLevel1) {
                        Config.heartbeatSound.play((Entity)hider, Config.seekerPingVolume, Config.seekerPingPitch);
                    }
                    if (distance >= Config.seekerPingLevel3) break;
                    Config.ringingSound.play((Entity)hider, Config.seekerPingVolume, Config.seekerPingPitch);
                    break;
                }
                case 6: {
                    if (distance >= Config.seekerPingLevel3) break;
                    Config.ringingSound.play((Entity)hider, Config.seekerPingVolume, Config.seekerPingPitch);
                    break;
                }
                case 9: {
                    if (distance >= Config.seekerPingLevel2) break;
                    Config.ringingSound.play((Entity)hider, Config.seekerPingVolume, Config.seekerPingPitch);
                }
            }
        }
        if (this.gameTick % 20 == 0) {
            if (Config.gameLength > 0) {
                this.board.reloadGameBoards();
                --this.gameTimer;
            }
            if (this.currentMap.isWorldBorderEnabled()) {
                this.currentMap.getWorldBorder().update();
            }
            if (Config.tauntEnabled) {
                this.taunt.update();
            }
            if (Config.glowEnabled || Config.alwaysGlow) {
                this.glow.update();
            }
        }
        this.board.getSpectators().forEach(spectator -> spectator.setFlying(spectator.getAllowFlight()));
        this.checkWinConditions();
    }

    public void broadcastMessage(String message) {
        for (Player player : this.board.getPlayers()) {
            player.sendMessage(message);
        }
    }

    public boolean isCurrentMapValid() {
        return this.currentMap != null && !this.currentMap.isNotSetup();
    }

    public boolean checkCurrentMap() {
        if (this.currentMap != null && !this.currentMap.isNotSetup()) {
            return false;
        }
        this.currentMap = Maps.getRandomMap();
        return this.currentMap == null;
    }

    public void setCurrentMap(Map map) {
        this.currentMap = map;
    }

    public Map getCurrentMap() {
        return this.currentMap;
    }

    private void checkWinConditions() {
        if (this.board.sizeHider() < 1) {
            if (this.hiderLeft) {
                if (Config.announceMessagesToNonPlayers) {
                    Bukkit.broadcastMessage((String)(Config.gameOverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_QUIT")));
                } else {
                    this.broadcastMessage(Config.gameOverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_QUIT"));
                }
                this.stop(WinType.NONE);
            } else {
                if (Config.announceMessagesToNonPlayers) {
                    Bukkit.broadcastMessage((String)(Config.gameOverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_FOUND")));
                } else {
                    this.broadcastMessage(Config.gameOverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_FOUND"));
                }
                this.stop(WinType.SEEKER_WIN);
            }
        } else if (this.board.sizeSeeker() < 1) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.abortPrefix + Localization.message("GAME_GAMEOVER_SEEKERS_QUIT")));
            } else {
                this.broadcastMessage(Config.abortPrefix + Localization.message("GAME_GAMEOVER_SEEKERS_QUIT"));
            }
            this.stop(WinType.NONE);
        } else if (this.gameTimer < 1) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.gameOverPrefix + Localization.message("GAME_GAMEOVER_TIME")));
            } else {
                this.broadcastMessage(Config.gameOverPrefix + Localization.message("GAME_GAMEOVER_TIME"));
            }
            this.stop(WinType.HIDER_WIN);
        }
        this.hiderLeft = false;
    }
}

