/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.database.Database;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameDataTable {
    private final Database database;

    protected NameDataTable(Database database) {
        String sql = "CREATE TABLE IF NOT EXISTS hs_names (\n\tuuid BINARY(16) NOT NULL,\n\tname VARCHAR(48) NOT NULL,\n\tPRIMARY KEY (uuid,name)\n);";
        try (Connection connection = database.connect();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        this.database = database;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getName(@NotNull UUID uuid) {
        String sql = "SELECT * FROM hs_names WHERE uuid = ?;";
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, this.database.encodeUUID(uuid));
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                String string = rs.getString("name");
                return string;
            }
            rs.close();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        OfflinePlayer retry = Bukkit.getOfflinePlayer((UUID)uuid);
        if (retry == null) return null;
        if (retry.getName() == null) return null;
        this.update(uuid, retry.getName());
        return retry.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public UUID getUUID(@NotNull String name) {
        String sql = "SELECT * FROM hs_names WHERE name = ?;";
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, name);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                UUID uUID = this.database.decodeUUID(rs.getBytes("uuid"));
                return uUID;
            }
            rs.close();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        OfflinePlayer retry = Bukkit.getOfflinePlayer((String)name);
        if (retry == null) return null;
        this.update(retry.getUniqueId(), name);
        return retry.getUniqueId();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean update(@NotNull UUID uuid, @NotNull String name) {
        String sql = "INSERT OR REPLACE INTO hs_names (uuid, name) VALUES (?,?)";
        try (Connection connection = this.database.connect();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setBytes(1, this.database.encodeUUID(uuid));
                    statement.setString(2, name);
                    statement.execute();
                    statement.close();
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

