/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.database.Database;
import net.tylermurphy.hideAndSeek.database.util.PlayerInfo;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.util.WinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameDataTable {
    private final Map<UUID, PlayerInfo> CACHE = new HashMap<UUID, PlayerInfo>();
    private final Database database;

    protected GameDataTable(Database database) {
        String sql = "CREATE TABLE IF NOT EXISTS hs_data (\n\tuuid BINARY(16) PRIMARY KEY,\n\thider_wins int NOT NULL,\n\tseeker_wins int NOT NULL,\n\thider_games int NOT NULL,\n\tseeker_games int NOT NULL,\n\thider_kills int NOT NULL,\n\tseeker_kills int NOT NULL,\n\thider_deaths int NOT NULL,\n\tseeker_deaths int NOT NULL\n);";
        try (Connection connection = database.connect();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        this.database = database;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PlayerInfo getInfo(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        if (this.CACHE.containsKey(uuid)) {
            return this.CACHE.get(uuid);
        }
        String sql = "SELECT * FROM hs_data WHERE uuid = ?;";
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, this.database.encodeUUID(uuid));
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                PlayerInfo info = new PlayerInfo(uuid, rs.getInt("hider_wins"), rs.getInt("seeker_wins"), rs.getInt("hider_games"), rs.getInt("seeker_games"), rs.getInt("hider_kills"), rs.getInt("seeker_kills"), rs.getInt("hider_deaths"), rs.getInt("seeker_deaths"));
                rs.close();
                connection.close();
                this.CACHE.put(uuid, info);
                PlayerInfo playerInfo = info;
                return playerInfo;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PlayerInfo getInfoRanking(@NotNull String order, int place) {
        String sql = "SELECT * FROM hs_data ORDER BY " + order + " DESC LIMIT 1 OFFSET ?;";
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, place - 1);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                UUID uuid = this.database.decodeUUID(rs.getBytes("uuid"));
                PlayerInfo info = new PlayerInfo(uuid, rs.getInt("hider_wins"), rs.getInt("seeker_wins"), rs.getInt("hider_games"), rs.getInt("seeker_games"), rs.getInt("hider_kills"), rs.getInt("seeker_kills"), rs.getInt("hider_deaths"), rs.getInt("seeker_deaths"));
                rs.close();
                connection.close();
                this.CACHE.put(uuid, info);
                PlayerInfo playerInfo = info;
                return playerInfo;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public List<PlayerInfo> getInfoPage(int page) {
        String sql = "SELECT * FROM hs_data ORDER BY (hider_wins + seeker_wins) DESC LIMIT 10 OFFSET ?;";
        try (Connection connection = this.database.connect();){
            ArrayList<PlayerInfo> arrayList;
            block15: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, (page - 1) * 10);
                    ResultSet rs = statement.executeQuery();
                    ArrayList<PlayerInfo> infoList = new ArrayList<PlayerInfo>();
                    while (rs.next()) {
                        PlayerInfo info = new PlayerInfo(this.database.decodeUUID(rs.getBytes("uuid")), rs.getInt("hider_wins"), rs.getInt("seeker_wins"), rs.getInt("hider_games"), rs.getInt("seeker_games"), rs.getInt("hider_kills"), rs.getInt("seeker_kills"), rs.getInt("hider_deaths"), rs.getInt("seeker_deaths"));
                        infoList.add(info);
                    }
                    rs.close();
                    connection.close();
                    arrayList = infoList;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Integer getRanking(@NotNull String order, @NotNull UUID uuid) {
        String sql = "SELECT count(*) AS total FROM hs_data WHERE " + order + " >= (SELECT " + order + " FROM hs_data WHERE uuid = ?) AND " + order + " > 0;";
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, this.database.encodeUUID(uuid));
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                Integer n = rs.getInt("total");
                return n;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public void addWins(@NotNull Board board, @NotNull List<UUID> uuids, @NotNull List<UUID> winners, @NotNull Map<UUID, Integer> hider_kills, @NotNull Map<UUID, Integer> hider_deaths, @NotNull Map<UUID, Integer> seeker_kills, @NotNull Map<UUID, Integer> seeker_deaths, @NotNull WinType type) {
        for (UUID uuid : uuids) {
            PlayerInfo info = this.getInfo(uuid);
            if (info == null) {
                info = new PlayerInfo(uuid, 0, 0, 0, 0, 0, 0, 0, 0);
            }
            this.updateInfo(this.database.encodeUUID(info.getUniqueId()), info.getHiderWins() + (winners.contains(uuid) && type == WinType.HIDER_WIN ? 1 : 0), info.getSeekerWins() + (winners.contains(uuid) && type == WinType.SEEKER_WIN ? 1 : 0), info.getHiderGames() + (board.isHider(uuid) || board.isSeeker(uuid) && !board.getFirstSeeker().getUniqueId().equals(uuid) ? 1 : 0), info.getSeekerGames() + (board.getFirstSeeker().getUniqueId().equals(uuid) ? 1 : 0), info.getHiderKills() + hider_kills.getOrDefault(uuid, 0), info.getSeekerKills() + seeker_kills.getOrDefault(uuid, 0), info.getHiderDeaths() + hider_deaths.getOrDefault(uuid, 0), info.getSeekerDeaths() + seeker_deaths.getOrDefault(uuid, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInfo(byte[] uuid, int hider_wins, int seeker_wins, int hider_games, int seeker_games, int hider_kills, int seeker_kills, int hider_deaths, int seeker_deaths) {
        String sql = "INSERT OR REPLACE INTO hs_data (uuid, hider_wins, seeker_wins, hider_games, seeker_games, hider_kills, seeker_kills, hider_deaths, seeker_deaths) VALUES (?,?,?,?,?,?,?,?,?)";
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, uuid);
            statement.setInt(2, hider_wins);
            statement.setInt(3, seeker_wins);
            statement.setInt(4, hider_games);
            statement.setInt(5, seeker_games);
            statement.setInt(6, hider_kills);
            statement.setInt(7, seeker_kills);
            statement.setInt(8, hider_deaths);
            statement.setInt(9, seeker_deaths);
            statement.execute();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.CACHE.remove(this.database.decodeUUID(uuid));
        }
    }
}

