/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.util.ArrayList;
import java.util.List;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.game.events.Border;
import net.tylermurphy.hideAndSeek.util.Location;
import net.tylermurphy.hideAndSeek.world.WorldLoader;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Map {
    private final String name;
    private Location spawnPosition = Location.getDefault();
    private Location lobbyPosition = Location.getDefault();
    private Location seekerLobbyPosition = Location.getDefault();
    private int xBoundMin = 0;
    private int zBoundMin = 0;
    private int xBoundMax = 0;
    private int zBoundMax = 0;
    private int xWorldBorder = 0;
    private int zWorldBorder = 0;
    private int worldBorderSize = 0;
    private int worldBorderDelay = 0;
    private int worldBorderChange = 0;
    private boolean blockhunt = false;
    private List<Material> blockhuntBlocks = new ArrayList<Material>();
    private final Border worldBorder;
    private final WorldLoader worldLoader;

    public Map(String name) {
        this.name = name;
        this.worldBorder = new Border(this);
        this.worldLoader = new WorldLoader(this);
    }

    public void setSpawn(Location pos) {
        this.spawnPosition = pos;
    }

    public void setLobby(Location pos) {
        this.lobbyPosition = pos;
    }

    public void setSeekerLobby(Location pos) {
        this.seekerLobbyPosition = pos;
    }

    public void setWorldBorderData(int x, int z, int size, int delay, int move) {
        if (size < 1) {
            this.worldBorderSize = 0;
            this.worldBorderDelay = 0;
            this.worldBorderChange = 0;
            this.xWorldBorder = 0;
            this.zWorldBorder = 0;
        } else {
            this.worldBorderSize = size;
            this.worldBorderDelay = delay;
            this.worldBorderChange = move;
            this.xWorldBorder = x;
            this.zWorldBorder = z;
        }
        this.worldBorder.resetWorldBorder();
    }

    public void setBlockhunt(boolean enabled, List<Material> blocks) {
        this.blockhunt = Main.getInstance().supports(9) ? enabled : false;
        this.blockhuntBlocks = blocks;
    }

    public void setBoundMin(int x, int z) {
        this.xBoundMin = x;
        this.zBoundMin = z;
    }

    public void setBoundMax(int x, int z) {
        this.xBoundMax = x;
        this.zBoundMax = z;
    }

    @NotNull
    public Location getGameSpawn() {
        if (Config.mapSaveEnabled) {
            return this.spawnPosition.changeWorld("hs_" + this.name);
        }
        return this.spawnPosition;
    }

    @NotNull
    public String getGameSpawnName() {
        if (Config.mapSaveEnabled) {
            return this.getGameSpawn().getWorld();
        }
        return this.getSpawn().getWorld();
    }

    @NotNull
    public Location getSpawn() {
        return this.spawnPosition;
    }

    @NotNull
    public String getSpawnName() {
        return this.getSpawn().getWorld();
    }

    @NotNull
    public Location getLobby() {
        return this.lobbyPosition;
    }

    @NotNull
    public String getLobbyName() {
        return this.getLobby().getWorld();
    }

    @NotNull
    public Location getSeekerLobby() {
        return this.seekerLobbyPosition;
    }

    @NotNull
    public String getSeekerLobbyName() {
        return this.getSeekerLobby().getWorld();
    }

    @NotNull
    public Location getGameSeekerLobby() {
        if (Config.mapSaveEnabled) {
            return this.seekerLobbyPosition.changeWorld("hs_" + this.name);
        }
        return this.seekerLobbyPosition;
    }

    public boolean isWorldBorderEnabled() {
        return this.worldBorderSize > 0;
    }

    @NotNull
    public Vector getWorldBorderPos() {
        return new Vector(this.xWorldBorder, 0, this.zWorldBorder);
    }

    @NotNull
    public Vector getWorldBorderData() {
        return new Vector(this.worldBorderSize, this.worldBorderDelay, this.worldBorderChange);
    }

    @NotNull
    public Border getWorldBorder() {
        return this.worldBorder;
    }

    public boolean isBlockHuntEnabled() {
        return this.blockhunt;
    }

    @NotNull
    public List<Material> getBlockHunt() {
        return this.blockhuntBlocks;
    }

    @NotNull
    public Vector getBoundsMin() {
        return new Vector(this.xBoundMin, 0, this.zBoundMin);
    }

    @NotNull
    public Vector getBoundsMax() {
        return new Vector(this.xBoundMax, 0, this.zBoundMax);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public WorldLoader getWorldLoader() {
        return this.worldLoader;
    }

    public boolean isNotSetup() {
        if (this.spawnPosition.getBlockX() == 0 && this.spawnPosition.getBlockY() == 0 && this.spawnPosition.getBlockZ() == 0 || !this.spawnPosition.exists()) {
            return true;
        }
        if (this.lobbyPosition.getBlockX() == 0 && this.lobbyPosition.getBlockY() == 0 && this.lobbyPosition.getBlockZ() == 0 || !this.lobbyPosition.exists()) {
            return true;
        }
        if (Config.exitPosition == null || Config.exitPosition.getBlockX() == 0 && Config.exitPosition.getBlockY() == 0 && Config.exitPosition.getBlockZ() == 0 || !Config.exitPosition.exists()) {
            return true;
        }
        if (this.seekerLobbyPosition.getBlockX() == 0 && this.seekerLobbyPosition.getBlockY() == 0 && this.seekerLobbyPosition.getBlockZ() == 0 || !this.seekerLobbyPosition.exists()) {
            return true;
        }
        if (Config.mapSaveEnabled && !this.getGameSpawn().exists()) {
            return true;
        }
        if (this.blockhunt && this.blockhuntBlocks.isEmpty()) {
            return true;
        }
        if (this.isWorldBorderEnabled()) {
            Vector vector = new Vector(this.spawnPosition.getX(), 0.0, this.spawnPosition.getZ());
            Vector vector2 = new Vector(this.xWorldBorder, 0, this.zWorldBorder);
            if (vector.distance(vector2) > 100.0) {
                return true;
            }
        }
        return this.xBoundMin == 0 || this.zBoundMin == 0 || this.xBoundMax == 0 || this.zBoundMax == 0;
    }

    public boolean isBoundsNotSetup() {
        return this.xBoundMin == 0 || this.zBoundMin == 0 || this.xBoundMax == 0 || this.zBoundMax == 0;
    }
}

