/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.util.ArrayList;
import java.util.List;
import net.tylermurphy.dependencies.xseries.XItemStack;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Items {
    public static List<ItemStack> HIDER_ITEMS;
    public static List<ItemStack> SEEKER_ITEMS;
    public static List<PotionEffect> HIDER_EFFECTS;
    public static List<PotionEffect> SEEKER_EFFECTS;

    public static void loadItems() {
        ConfigurationSection section;
        ConfigurationSection section2;
        ConfigurationSection section3;
        ConfigurationSection section4;
        ConfigManager manager = ConfigManager.create("items.yml");
        SEEKER_ITEMS = new ArrayList<ItemStack>();
        ConfigurationSection SeekerItems = manager.getConfigurationSection("items.seeker");
        int i = 1;
        while ((section4 = SeekerItems.getConfigurationSection(String.valueOf(i))) != null) {
            ItemStack item = Items.createItem(section4);
            if (item != null) {
                SEEKER_ITEMS.add(item);
            }
            ++i;
        }
        HIDER_ITEMS = new ArrayList<ItemStack>();
        ConfigurationSection HiderItems = manager.getConfigurationSection("items.hider");
        i = 1;
        while ((section3 = HiderItems.getConfigurationSection(String.valueOf(i))) != null) {
            ItemStack item = Items.createItem(section3);
            if (item != null) {
                HIDER_ITEMS.add(item);
            }
            ++i;
        }
        SEEKER_EFFECTS = new ArrayList<PotionEffect>();
        ConfigurationSection SeekerEffects = manager.getConfigurationSection("effects.seeker");
        i = 1;
        while ((section2 = SeekerEffects.getConfigurationSection(String.valueOf(i))) != null) {
            PotionEffect effect = Items.getPotionEffect(section2);
            if (effect != null) {
                SEEKER_EFFECTS.add(effect);
            }
            ++i;
        }
        HIDER_EFFECTS = new ArrayList<PotionEffect>();
        ConfigurationSection HiderEffects = manager.getConfigurationSection("effects.hider");
        i = 1;
        while ((section = HiderEffects.getConfigurationSection(String.valueOf(i))) != null) {
            PotionEffect effect = Items.getPotionEffect(section);
            if (effect != null) {
                HIDER_EFFECTS.add(effect);
            }
            ++i;
        }
    }

    private static ItemStack createItem(ConfigurationSection item) {
        ConfigurationSection config = new YamlConfiguration().createSection("temp");
        String material = item.getString("material").toUpperCase();
        boolean splash = false;
        if (!Main.getInstance().supports(9)) {
            if (material.contains("POTION")) {
                config.set("level", (Object)1);
            }
            if (material.equalsIgnoreCase("SPLASH_POTION") || material.equalsIgnoreCase("LINGERING_POTION")) {
                material = "POTION";
                splash = true;
            }
        }
        config.set("name", (Object)item.getString("name"));
        config.set("material", (Object)material);
        config.set("enchants", (Object)item.getConfigurationSection("enchantments"));
        config.set("unbreakable", (Object)item.getBoolean("unbreakable"));
        if (Main.getInstance().supports(14) && item.contains("model-data")) {
            config.set("model-data", (Object)item.getInt("model-data"));
        }
        if (item.isSet("lore")) {
            config.set("lore", (Object)item.getStringList("lore"));
        }
        if (material.equalsIgnoreCase("POTION") || material.equalsIgnoreCase("SPLASH_POTION") || material.equalsIgnoreCase("LINGERING_POTION")) {
            config.set("base-effect", (Object)String.format("%s,%s,%s", item.getString("type"), false, splash));
        }
        ItemStack stack = XItemStack.deserialize(config);
        stack.setAmount(item.getInt("amount"));
        if (stack.getData().getItemType() == Material.AIR) {
            return null;
        }
        return stack;
    }

    private static PotionEffect getPotionEffect(ConfigurationSection item) {
        String type = item.getString("type");
        if (type == null) {
            return null;
        }
        if (PotionEffectType.getByName((String)type.toUpperCase()) == null) {
            return null;
        }
        return new PotionEffect(PotionEffectType.getByName((String)type.toUpperCase()), item.getInt("duration"), item.getInt("amplifier"), item.getBoolean("ambient"), item.getBoolean("particles"));
    }

    public static boolean matchItem(ItemStack stack) {
        for (ItemStack check : HIDER_ITEMS) {
            if (!Items.equals(stack, check)) continue;
            return true;
        }
        for (ItemStack check : SEEKER_ITEMS) {
            if (!Items.equals(stack, check)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(ItemStack a, ItemStack b) {
        if (a == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        return a.getType() == b.getType() && a.hasItemMeta() == b.hasItemMeta() && (!a.hasItemMeta() || Bukkit.getItemFactory().equals(a.getItemMeta(), b.getItemMeta()));
    }
}

