/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import net.tylermurphy.hideAndSeek.Main;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final File file;
    private YamlConfiguration config;
    private YamlConfiguration defaultConfig;
    private String defaultFilename;

    public static ConfigManager create(String filename) {
        return new ConfigManager(filename, filename);
    }

    public static ConfigManager create(String filename, String defaultFilename) {
        return new ConfigManager(filename, defaultFilename);
    }

    private ConfigManager(String filename, String defaultFilename) {
        FileInputStream fileInputStream;
        File dataFolder = Main.getInstance().getDataFolder();
        File oldDataFolder = new File(Main.getInstance().getDataFolder().getParent() + File.separator + "HideAndSeek");
        this.defaultFilename = defaultFilename;
        this.file = new File(dataFolder, filename);
        if (oldDataFolder.exists()) {
            if (!dataFolder.exists()) {
                if (!oldDataFolder.renameTo(dataFolder)) {
                    throw new RuntimeException("Could not rename folder: " + oldDataFolder.getPath());
                }
            } else {
                throw new RuntimeException("Plugin folders for HideAndSeek & KenshinsHideAndSeek both exists. There can only be one!");
            }
        }
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            throw new RuntimeException("Failed to make directory: " + this.file.getPath());
        }
        if (!this.file.exists()) {
            try {
                InputStream input = Main.getInstance().getResource(defaultFilename);
                if (input == null) {
                    throw new RuntimeException("Could not create input stream for " + defaultFilename);
                }
                Files.copy(input, this.file.toPath(), new CopyOption[0]);
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            fileInputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not create input stream for " + this.file.getPath());
        }
        InputStreamReader reader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
        this.config = new YamlConfiguration();
        try {
            this.config.load((Reader)reader);
        }
        catch (InvalidConfigurationException e) {
            Main.getInstance().getLogger().severe(e.getMessage());
            throw new RuntimeException("Invalid configuration in config file: " + this.file.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not access file: " + this.file.getPath());
        }
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(defaultFilename);
        if (input == null) {
            throw new RuntimeException("Could not create input stream for " + defaultFilename);
        }
        InputStreamReader default_reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        this.defaultConfig = new YamlConfiguration();
        try {
            this.defaultConfig.load((Reader)default_reader);
        }
        catch (InvalidConfigurationException e) {
            Main.getInstance().getLogger().severe(e.getMessage());
            throw new RuntimeException("Invalid configuration in internal config file: " + defaultFilename);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not access internal file: " + defaultFilename);
        }
        try {
            fileInputStream.close();
            default_reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to finalize loading of config files.");
        }
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }

    public double getDouble(String path) {
        if (!this.config.contains(path)) {
            return this.defaultConfig.getDouble(path);
        }
        return this.config.getDouble(path);
    }

    public int getInt(String path) {
        if (!this.config.contains(path)) {
            return this.defaultConfig.getInt(path);
        }
        return this.config.getInt(path);
    }

    public int getDefaultInt(String path) {
        return this.defaultConfig.getInt(path);
    }

    public float getFloat(String path) {
        if (!this.config.contains(path)) {
            return (float)this.defaultConfig.getDouble(path);
        }
        return (float)this.config.getDouble(path);
    }

    public String getString(String path) {
        String value = this.config.getString(path);
        if (value == null) {
            return this.defaultConfig.getString(path);
        }
        return value;
    }

    public String getString(String path, String oldPath) {
        String value = this.config.getString(path);
        if (value == null) {
            String oldValue = this.config.getString(oldPath);
            if (oldValue == null) {
                return this.defaultConfig.getString(path);
            }
            return oldValue;
        }
        return value;
    }

    public List<String> getStringList(String path) {
        List value = this.config.getStringList(path);
        if (value == null) {
            return this.defaultConfig.getStringList(path);
        }
        return value;
    }

    public void reset(String path) {
        this.config.set(path, this.defaultConfig.get(path));
    }

    public void resetFile(String newDefaultFilename) {
        this.defaultFilename = newDefaultFilename;
        InputStream input = Main.getInstance().getResource(this.defaultFilename);
        if (input == null) {
            throw new RuntimeException("Could not create input stream for " + this.defaultFilename);
        }
        InputStreamReader reader = new InputStreamReader(input);
        this.config = YamlConfiguration.loadConfiguration((Reader)reader);
        this.defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
    }

    public boolean getBoolean(String path) {
        if (!this.config.contains(path)) {
            return this.defaultConfig.getBoolean(path);
        }
        return this.config.getBoolean(path);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        ConfigurationSection section = this.config.getConfigurationSection(path);
        if (section == null) {
            return this.defaultConfig.getConfigurationSection(path);
        }
        return section;
    }

    public ConfigurationSection getDefaultConfigurationSection(String path) {
        return this.defaultConfig.getConfigurationSection(path);
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public void overwriteConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            int c;
            InputStream is = Main.getInstance().getResource(this.defaultFilename);
            if (is == null) {
                throw new RuntimeException("Could not create input stream for " + this.defaultFilename);
            }
            StringBuilder textBuilder = new StringBuilder(new String("".getBytes(), StandardCharsets.UTF_8));
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
            String yaml = new String(textBuilder.toString().getBytes(), StandardCharsets.UTF_8);
            Map data = this.config.getValues(true);
            for (Map.Entry entry : data.entrySet()) {
                int index;
                if (!this.isSupported(entry.getValue()) || (index = this.getIndex(yaml, (String)entry.getKey())) < 10) continue;
                int start = yaml.indexOf(32, index) + 1;
                int end = yaml.indexOf(10, index);
                if (end == -1) {
                    end = yaml.length();
                }
                StringBuilder replace = new StringBuilder(new String("".getBytes(), StandardCharsets.UTF_8));
                Object value = entry.getValue();
                if (value instanceof List) {
                    end = yaml.indexOf(93, start) + 1;
                    List list = (List)entry.getValue();
                    if (list.isEmpty()) {
                        replace.append("[]");
                    } else {
                        int gap = this.whitespaceBefore(yaml, index);
                        String space = new String(new char[gap]).replace('\u0000', ' ');
                        replace.append("[\n");
                        for (int i = 0; i < list.size(); ++i) {
                            replace.append(space).append("  ").append(this.convert(list.get(i)));
                            if (i == list.size() - 1) continue;
                            replace.append(",\n");
                        }
                        replace.append('\n').append(space).append("]");
                    }
                } else {
                    replace.append(this.convert(value));
                }
                StringBuilder builder = new StringBuilder(yaml);
                builder.replace(start, end, replace.toString());
                yaml = builder.toString();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            fileWriter.write(yaml);
            ((Writer)fileWriter).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getIndex(String yaml, String key) {
        String[] parts = key.split("\\.");
        int index = 0;
        for (String part : parts) {
            if ((index = index == 0 ? yaml.indexOf("\n" + part + ":", index) + 1 : yaml.indexOf(" " + part + ":", index) + 1) == 0) break;
        }
        return index;
    }

    public boolean isSupported(Object o) {
        return o instanceof Integer || o instanceof Double || o instanceof String || o instanceof Boolean || o instanceof List;
    }

    public int whitespaceBefore(String yaml, int index) {
        int count = 0;
        int i = index - 1;
        while (yaml.charAt(i) == ' ') {
            ++count;
            --i;
        }
        return count;
    }

    private String convert(Object o) {
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "true" : "false";
        }
        return o.toString();
    }
}

