/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.tylermurphy.dependencies.xseries.XItemStack;
import net.tylermurphy.dependencies.xseries.XMaterial;
import net.tylermurphy.dependencies.xseries.XSound;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.ConfigManager;
import net.tylermurphy.hideAndSeek.game.util.CountdownDisplay;
import net.tylermurphy.hideAndSeek.util.Location;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static ConfigManager config;
    public static String messagePrefix;
    public static String errorPrefix;
    public static String tauntPrefix;
    public static String worldBorderPrefix;
    public static String abortPrefix;
    public static String gameOverPrefix;
    public static String warningPrefix;
    public static String locale;
    public static String leaveServer;
    public static String placeholderError;
    public static String placeholderNoData;
    public static String databaseType;
    public static String databaseHost;
    public static String databasePort;
    public static String databaseUser;
    public static String databasePass;
    public static String databaseName;
    public static boolean nameTagsVisible;
    public static boolean permissionsRequired;
    public static boolean announceMessagesToNonPlayers;
    public static boolean tauntEnabled;
    public static boolean tauntCountdown;
    public static boolean tauntLast;
    public static boolean alwaysGlow;
    public static boolean glowEnabled;
    public static boolean glowStackable;
    public static boolean pvpEnabled;
    public static boolean autoJoin;
    public static boolean teleportToExit;
    public static boolean lobbyCountdownEnabled;
    public static boolean seekerPing;
    public static boolean bungeeLeave;
    public static boolean lobbyItemStartAdmin;
    public static boolean leaveOnEnd;
    public static boolean mapSaveEnabled;
    public static boolean allowNaturalCauses;
    public static boolean saveInventory;
    public static boolean delayedRespawn;
    public static int minPlayers;
    public static int gameLength;
    public static int tauntDelay;
    public static int glowLength;
    public static int countdown;
    public static int changeCountdown;
    public static int lobbyMin;
    public static int lobbyMax;
    public static int seekerPingLevel1;
    public static int seekerPingLevel2;
    public static int seekerPingLevel3;
    public static int lobbyItemLeavePosition;
    public static int lobbyItemStartPosition;
    public static int flightToggleItemPosition;
    public static int teleportItemPosition;
    public static int delayedRespawnDelay;
    public static float seekerPingLeadingVolume;
    public static float seekerPingVolume;
    public static float seekerPingPitch;
    public static List<String> blockedCommands;
    public static List<String> blockedInteracts;
    public static ItemStack lobbyLeaveItem;
    public static ItemStack lobbyStartItem;
    public static ItemStack glowPowerupItem;
    public static ItemStack flightToggleItem;
    public static ItemStack teleportItem;
    public static XSound ringingSound;
    public static XSound heartbeatSound;
    public static CountdownDisplay countdownDisplay;
    public static Location exitPosition;

    public static void loadConfig() {
        config = ConfigManager.create("config.yml");
        config.saveConfig();
        announceMessagesToNonPlayers = config.getBoolean("announceMessagesToNonPlayers");
        char SYMBOL = '\u00a7';
        String SYMBOL_STRING = String.valueOf(SYMBOL);
        messagePrefix = config.getString("prefix.default").replace("&", SYMBOL_STRING);
        errorPrefix = config.getString("prefix.error").replace("&", SYMBOL_STRING);
        tauntPrefix = config.getString("prefix.taunt").replace("&", SYMBOL_STRING);
        worldBorderPrefix = config.getString("prefix.border").replace("&", SYMBOL_STRING);
        abortPrefix = config.getString("prefix.abort").replace("&", SYMBOL_STRING);
        gameOverPrefix = config.getString("prefix.gameover").replace("&", SYMBOL_STRING);
        warningPrefix = config.getString("prefix.warning").replace("&", SYMBOL_STRING);
        exitPosition = new Location(config.getString("exit.world"), config.getInt("exit.x"), config.getInt("exit.y"), config.getInt("exit.z"));
        mapSaveEnabled = config.getBoolean("mapSaveEnabled");
        tauntEnabled = config.getBoolean("taunt.enabled");
        tauntCountdown = config.getBoolean("taunt.showCountdown");
        tauntDelay = Math.max(60, config.getInt("taunt.delay"));
        tauntLast = config.getBoolean("taunt.whenLastPerson");
        alwaysGlow = config.getBoolean("alwaysGlow") && Main.getInstance().supports(9);
        glowLength = Math.max(1, config.getInt("glow.time"));
        glowStackable = config.getBoolean("glow.stackable");
        boolean bl = glowEnabled = config.getBoolean("glow.enabled") && Main.getInstance().supports(9) && !alwaysGlow;
        if (glowEnabled) {
            glowPowerupItem = Config.createItemStack("glow");
        }
        minPlayers = Math.max(2, config.getInt("minPlayers"));
        countdown = Math.max(10, config.getInt("lobby.countdown"));
        changeCountdown = Math.max(minPlayers, config.getInt("lobby.changeCountdown"));
        lobbyMin = Math.max(minPlayers, config.getInt("lobby.min"));
        lobbyMax = config.getInt("lobby.max");
        lobbyCountdownEnabled = config.getBoolean("lobby.enabled");
        seekerPing = config.getBoolean("seekerPing.enabled");
        seekerPingLevel1 = config.getInt("seekerPing.distances.level1");
        seekerPingLevel2 = config.getInt("seekerPing.distances.level2");
        seekerPingLevel3 = config.getInt("seekerPing.distances.level3");
        seekerPingLeadingVolume = config.getFloat("seekerPing.sounds.leadingVolume");
        seekerPingVolume = config.getFloat("seekerPing.sounds.volume");
        seekerPingPitch = config.getFloat("seekerPing.sounds.pitch");
        Optional<XSound> heartbeatOptional = XSound.matchXSound(config.getString("seekerPing.sounds.heartbeatNoise"));
        heartbeatSound = heartbeatOptional.orElse(XSound.BLOCK_NOTE_BLOCK_BASEDRUM);
        Optional<XSound> ringingOptional = XSound.matchXSound(config.getString("seekerPing.sounds.ringingNoise"));
        ringingSound = ringingOptional.orElse(XSound.BLOCK_NOTE_BLOCK_PLING);
        nameTagsVisible = config.getBoolean("nametagsVisible");
        permissionsRequired = config.getBoolean("permissionsRequired");
        gameLength = config.getInt("gameLength");
        pvpEnabled = config.getBoolean("pvp");
        allowNaturalCauses = config.getBoolean("allowNaturalCauses");
        autoJoin = config.getBoolean("autoJoin");
        teleportToExit = config.getBoolean("teleportToExit");
        locale = config.getString("locale", "local");
        blockedCommands = config.getStringList("blockedCommands");
        leaveOnEnd = config.getBoolean("leaveOnEnd");
        placeholderError = config.getString("placeholder.incorrect");
        placeholderNoData = config.getString("placeholder.noData");
        saveInventory = config.getBoolean("saveInventory");
        try {
            countdownDisplay = CountdownDisplay.valueOf(config.getString("hideCountdownDisplay"));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("hideCountdownDisplay: " + config.getString("hideCountdownDisplay") + ", is not a valid configuration option!");
        }
        blockedInteracts = new ArrayList<String>();
        List<String> tempInteracts = config.getStringList("blockedInteracts");
        for (String id : tempInteracts) {
            Material mat;
            Optional<XMaterial> optional_mat = XMaterial.matchXMaterial(id);
            if (!optional_mat.isPresent() || (mat = optional_mat.get().parseMaterial()) == null) continue;
            blockedInteracts.add(mat.name());
        }
        bungeeLeave = config.getString("leaveType") == null || config.getString("leaveType").equalsIgnoreCase("proxy");
        leaveServer = config.getString("leaveServer");
        if (config.getBoolean("lobbyItems.leave.enabled")) {
            lobbyLeaveItem = Config.createItemStack("lobbyItems.leave");
            lobbyItemLeavePosition = config.getInt("lobbyItems.leave.position");
        }
        if (config.getBoolean("lobbyItems.start.enabled")) {
            lobbyStartItem = Config.createItemStack("lobbyItems.start");
            lobbyItemStartAdmin = config.getBoolean("lobbyItems.start.adminOnly");
            lobbyItemStartPosition = config.getInt("lobbyItems.start.position");
        }
        flightToggleItem = Config.createItemStack("spectatorItems.flight");
        flightToggleItemPosition = config.getInt("spectatorItems.flight.position");
        teleportItem = Config.createItemStack("spectatorItems.teleport");
        teleportItemPosition = config.getInt("spectatorItems.teleport.position");
        databaseHost = config.getString("databaseHost");
        databasePort = config.getString("databasePort");
        databaseUser = config.getString("databaseUser");
        databasePass = config.getString("databasePass");
        databaseName = config.getString("databaseName");
        databaseType = config.getString("databaseType").toUpperCase();
        if (!databaseType.equals("SQLITE") && !databaseType.equals("MYSQL")) {
            throw new RuntimeException("databaseType: " + databaseType + " is not a valid configuration option!");
        }
        delayedRespawn = config.getBoolean("delayedRespawn.enabled");
        delayedRespawnDelay = Math.max(0, config.getInt("delayedRespawn.delay"));
    }

    public static void addToConfig(String path, Object value) {
        config.set(path, value);
    }

    public static void saveConfig() {
        config.saveConfig();
    }

    @Nullable
    private static ItemStack createItemStack(String path) {
        List<String> lore;
        ConfigurationSection item = new YamlConfiguration().createSection("temp");
        item.set("name", (Object)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(path + ".name")));
        item.set("material", (Object)config.getString(path + ".material"));
        if (Main.getInstance().supports(14) && config.contains(path + ".model-data") && config.getInt(path + ".model-data") != 0) {
            item.set("model-data", (Object)config.getInt(path + ".model-data"));
        }
        if ((lore = config.getStringList(path + ".lore")) != null && !lore.isEmpty()) {
            item.set("lore", lore);
        }
        ItemStack temp = null;
        try {
            temp = XItemStack.deserialize(item);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return temp;
    }
}

