/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.world;

import java.io.File;
import java.util.List;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.Confirm;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.world.WorldLoader;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Delete
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        List<String> worlds = Main.getInstance().getWorlds();
        if (!worlds.contains(args[0])) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLD_DOESNT_EXIST").addAmount(args[0]));
            return;
        }
        Confirm.Confirmation confirmation = new Confirm.Confirmation(args[0], world -> {
            List<String> worlds_now = Main.getInstance().getWorlds();
            if (!worlds_now.contains(world)) {
                sender.sendMessage(Config.errorPrefix + Localization.message("WORLD_DOESNT_EXIST").addAmount((String)world));
                return;
            }
            World bukkit_world = Bukkit.getWorld((String)world);
            if (bukkit_world != null && bukkit_world.getPlayers().size() > 0) {
                sender.sendMessage(Config.errorPrefix + Localization.message("WORLD_NOT_EMPTY"));
                return;
            }
            String path = Main.getInstance().getWorldContainer().getPath() + File.separator + world;
            if (!Bukkit.getServer().unloadWorld(world, false)) {
                sender.sendMessage(Config.errorPrefix + Localization.message("WORLD_REMOVED_FAILED"));
                return;
            }
            try {
                WorldLoader.deleteDirectory(new File(path));
            }
            catch (Exception e) {
                sender.sendMessage(Config.errorPrefix + Localization.message("WORLD_REMOVED_FAILED"));
                return;
            }
            sender.sendMessage(Config.messagePrefix + Localization.message("WORLD_REMOVED").addAmount((String)world));
        });
        Confirm.confirmations.put(sender.getUniqueId(), confirmation);
        sender.sendMessage(Config.messagePrefix + Localization.message("CONFIRMATION"));
    }

    @Override
    public String getLabel() {
        return "delete";
    }

    @Override
    public String getUsage() {
        return "<name>";
    }

    @Override
    public String getDescription() {
        return "Delete a world";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("name")) {
            return Main.getInstance().getWorlds();
        }
        return null;
    }
}

