/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.map.set;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Border
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        int change;
        int delay;
        int num;
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        Map map = Maps.getMap(args[0]);
        if (map == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("INVALID_MAP"));
            return;
        }
        if (map.getSpawn().isNotSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("ERROR_GAME_SPAWN"));
            return;
        }
        if (args.length < 4) {
            map.setWorldBorderData(0, 0, 0, 0, 0);
            Config.addToConfig("worldBorder.enabled", false);
            Config.saveConfig();
            sender.sendMessage(Config.messagePrefix + Localization.message("WORLDBORDER_DISABLE"));
            Main.getInstance().getGame().getCurrentMap().getWorldBorder().resetWorldBorder();
            return;
        }
        try {
            num = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_INVALID_INPUT").addAmount(args[0]));
            return;
        }
        try {
            delay = Integer.parseInt(args[2]);
        }
        catch (Exception e) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_INVALID_INPUT").addAmount(args[1]));
            return;
        }
        try {
            change = Integer.parseInt(args[3]);
        }
        catch (Exception e) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_INVALID_INPUT").addAmount(args[2]));
            return;
        }
        if (num < 100) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_MIN_SIZE"));
            return;
        }
        if (change < 1) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_CHANGE_SIZE"));
            return;
        }
        map.setWorldBorderData(sender.getLocation().getBlockX(), sender.getLocation().getBlockZ(), num, delay, change);
        Maps.setMap(map.getName(), map);
        sender.sendMessage(Config.messagePrefix + Localization.message("WORLDBORDER_ENABLE").addAmount(num).addAmount(delay).addAmount(change));
        map.getWorldBorder().resetWorldBorder();
    }

    @Override
    public String getLabel() {
        return "border";
    }

    @Override
    public String getUsage() {
        return "<map> <*size> <*delay> <*move>";
    }

    @Override
    public String getDescription() {
        return "Sets a maps world border information";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("map")) {
            return Maps.getAllMaps().stream().map(Map::getName).collect(Collectors.toList());
        }
        return Collections.singletonList(parameter);
    }
}

