/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.List;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Start
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        if (Main.getInstance().getGame().checkCurrentMap()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        if (!Main.getInstance().getBoard().contains(sender)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_NOT_INGAME"));
            return;
        }
        if (Main.getInstance().getBoard().size() < Config.minPlayers) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_MIN_PLAYERS").addAmount(Config.minPlayers));
            return;
        }
        if (args.length < 1) {
            Main.getInstance().getGame().start();
            return;
        }
        String seekerName = args[0];
        Player seeker = Bukkit.getPlayer((String)seekerName);
        if (seeker == null || !Main.getInstance().getBoard().contains(seeker)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_INVALID_NAME").addPlayer(seekerName));
            return;
        }
        Main.getInstance().getGame().start(seeker);
    }

    @Override
    public String getLabel() {
        return "start";
    }

    @Override
    public String getUsage() {
        return "<*player>";
    }

    @Override
    public String getDescription() {
        return "Starts the game either with a random seeker or chosen one";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("player")) {
            return Main.getInstance().getBoard().getPlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
        }
        return null;
    }
}

