/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.tylermurphy.hideAndSeek.command.Confirm;
import net.tylermurphy.hideAndSeek.command.Help;
import net.tylermurphy.hideAndSeek.command.Join;
import net.tylermurphy.hideAndSeek.command.Leave;
import net.tylermurphy.hideAndSeek.command.Reload;
import net.tylermurphy.hideAndSeek.command.Send;
import net.tylermurphy.hideAndSeek.command.SetExitLocation;
import net.tylermurphy.hideAndSeek.command.Start;
import net.tylermurphy.hideAndSeek.command.Stop;
import net.tylermurphy.hideAndSeek.command.Top;
import net.tylermurphy.hideAndSeek.command.Wins;
import net.tylermurphy.hideAndSeek.command.map.Debug;
import net.tylermurphy.hideAndSeek.command.map.GoTo;
import net.tylermurphy.hideAndSeek.command.map.List;
import net.tylermurphy.hideAndSeek.command.map.Save;
import net.tylermurphy.hideAndSeek.command.map.blockhunt.Enabled;
import net.tylermurphy.hideAndSeek.command.map.blockhunt.blocks.Add;
import net.tylermurphy.hideAndSeek.command.map.blockhunt.blocks.Remove;
import net.tylermurphy.hideAndSeek.command.map.set.Border;
import net.tylermurphy.hideAndSeek.command.map.set.Bounds;
import net.tylermurphy.hideAndSeek.command.map.set.Lobby;
import net.tylermurphy.hideAndSeek.command.map.set.SeekerLobby;
import net.tylermurphy.hideAndSeek.command.map.set.Spawn;
import net.tylermurphy.hideAndSeek.command.util.CommandGroup;
import net.tylermurphy.hideAndSeek.command.world.Create;
import net.tylermurphy.hideAndSeek.command.world.Delete;
import net.tylermurphy.hideAndSeek.command.world.Tp;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Items;
import net.tylermurphy.hideAndSeek.configuration.Leaderboard;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.database.Database;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.Disguiser;
import net.tylermurphy.hideAndSeek.game.EntityHider;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.game.PlayerLoader;
import net.tylermurphy.hideAndSeek.game.listener.BlockedCommandHandler;
import net.tylermurphy.hideAndSeek.game.listener.ChatHandler;
import net.tylermurphy.hideAndSeek.game.listener.DamageHandler;
import net.tylermurphy.hideAndSeek.game.listener.DisguiseHandler;
import net.tylermurphy.hideAndSeek.game.listener.InteractHandler;
import net.tylermurphy.hideAndSeek.game.listener.InventoryHandler;
import net.tylermurphy.hideAndSeek.game.listener.JoinLeaveHandler;
import net.tylermurphy.hideAndSeek.game.listener.MovementHandler;
import net.tylermurphy.hideAndSeek.game.listener.PlayerHandler;
import net.tylermurphy.hideAndSeek.game.listener.RespawnHandler;
import net.tylermurphy.hideAndSeek.game.listener.WorldInteractHandler;
import net.tylermurphy.hideAndSeek.game.util.Status;
import net.tylermurphy.hideAndSeek.util.PAPIExpansion;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Main
extends JavaPlugin
implements Listener {
    private static Main instance;
    private static int version;
    private Database database;
    private Board board;
    private Disguiser disguiser;
    private EntityHider entityHider;
    private Game game;
    private CommandGroup commandGroup;
    private boolean loaded;

    public void onEnable() {
        long start = System.currentTimeMillis();
        this.getLogger().info("Loading Kenshin's Hide and Seek");
        instance = this;
        this.getLogger().info("Getting minecraft version...");
        this.updateVersion();
        try {
            this.getLogger().info("Loading config.yml...");
            Config.loadConfig();
            this.getLogger().info("Loading maps.yml...");
            Maps.loadMaps();
            this.getLogger().info("Loading localization.yml...");
            Localization.loadLocalization();
            this.getLogger().info("Loading items.yml...");
            Items.loadItems();
            this.getLogger().info("Loading leaderboard.yml...");
            Leaderboard.loadLeaderboard();
        }
        catch (Exception e) {
            this.getLogger().severe(e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Creating internal scoreboard...");
        this.board = new Board();
        this.getLogger().info("Connecting to database...");
        this.database = new Database();
        this.getLogger().info("Loading disguises...");
        this.disguiser = new Disguiser();
        this.getLogger().info("Loading entity hider...");
        this.entityHider = new EntityHider((Plugin)this, EntityHider.Policy.BLACKLIST);
        this.getLogger().info("Registering listeners...");
        this.registerListeners();
        this.getLogger().info("Registering commands...");
        this.commandGroup = new CommandGroup("hs", new Help(), new Reload(), new Join(), new Leave(), new Send(), new Start(), new Stop(), new CommandGroup("map", new CommandGroup("blockhunt", new CommandGroup("blocks", new Add(), new Remove(), new net.tylermurphy.hideAndSeek.command.map.blockhunt.blocks.List()), new Enabled()), new CommandGroup("set", new Lobby(), new Spawn(), new SeekerLobby(), new Border(), new Bounds()), new net.tylermurphy.hideAndSeek.command.map.Add(), new net.tylermurphy.hideAndSeek.command.map.Remove(), new List(), new net.tylermurphy.hideAndSeek.command.map.Status(), new Save(), new Debug(), new GoTo()), new CommandGroup("world", new Create(), new Delete(), new net.tylermurphy.hideAndSeek.command.world.List(), new Tp()), new SetExitLocation(), new Top(), new Wins(), new Confirm());
        this.getLogger().info("Loading game...");
        this.game = new Game(null, this.board);
        this.getLogger().info("Scheduling tick tasks...");
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this::onTick, 0L, 1L).getTaskId();
        this.getLogger().info("Registering outgoing bungeecord plugin channel...");
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getLogger().info("Checking for PlaceholderAPI...");
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getLogger().info("PlaceholderAPI found...");
            this.getLogger().info("Registering PlaceholderAPI expansion...");
            new PAPIExpansion().register();
        }
        long end = System.currentTimeMillis();
        this.getLogger().info("Finished loading plugin (" + (end - start) + "ms)");
        this.loaded = true;
    }

    public void onDisable() {
        version = 0;
        if (this.board != null) {
            this.board.getPlayers().forEach(player -> {
                this.board.removeBoard((Player)player);
                PlayerLoader.unloadPlayer(player);
                Config.exitPosition.teleport((Player)player);
            });
            this.board.cleanup();
        }
        if (this.disguiser != null) {
            this.disguiser.cleanUp();
        }
        Bukkit.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
    }

    private void onTick() {
        if (this.game.getStatus() == Status.ENDED) {
            this.game = new Game(this.game.getCurrentMap(), this.board);
        }
        this.game.onTick();
        this.disguiser.check();
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new BlockedCommandHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DamageHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DisguiseHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InteractHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinLeaveHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MovementHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RespawnHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldInteractHandler(), (Plugin)this);
    }

    private void updateVersion() {
        Matcher matcher = Pattern.compile("MC: \\d\\.(\\d+)").matcher(Bukkit.getVersion());
        if (!matcher.find()) {
            throw new IllegalArgumentException("Failed to parse server version from: " + Bukkit.getVersion());
        }
        version = Integer.parseInt(matcher.group(1));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_PLAYER_ONLY"));
            return true;
        }
        this.commandGroup.handleCommand((Player)sender, args);
        return true;
    }

    public java.util.List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_PLAYER_ONLY"));
            return new ArrayList<String>();
        }
        return this.commandGroup.handleTabComplete((Player)sender, args);
    }

    public static Main getInstance() {
        return instance;
    }

    public File getWorldContainer() {
        return this.getServer().getWorldContainer();
    }

    public Database getDatabase() {
        return this.database;
    }

    public Board getBoard() {
        return this.board;
    }

    public Game getGame() {
        return this.game;
    }

    public Disguiser getDisguiser() {
        return this.disguiser;
    }

    public EntityHider getEntityHider() {
        return this.entityHider;
    }

    public CommandGroup getCommandGroup() {
        return this.commandGroup;
    }

    public boolean supports(int v) {
        return version >= v;
    }

    public java.util.List<String> getWorlds() {
        ArrayList<String> worlds = new ArrayList<String>();
        File[] containers = this.getWorldContainer().listFiles();
        if (containers != null) {
            Arrays.stream(containers).forEach(file -> {
                if (!file.isDirectory()) {
                    return;
                }
                String[] files = file.list();
                if (files == null) {
                    return;
                }
                if (!Arrays.asList(files).contains("session.lock") && !Arrays.asList(files).contains("level.dat")) {
                    return;
                }
                worlds.add(file.getName());
            });
        }
        return worlds;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void scheduleTask(Runnable task) {
        if (!this.isEnabled()) {
            return;
        }
        Bukkit.getServer().getScheduler().runTask((Plugin)this, task);
    }
}

