/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.dependencies.xseries;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.tylermurphy.dependencies.xseries.SkullUtils;
import net.tylermurphy.dependencies.xseries.XEnchantment;
import net.tylermurphy.dependencies.xseries.XMaterial;
import net.tylermurphy.dependencies.xseries.XPotion;
import net.tylermurphy.dependencies.xseries.XTag;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;
import org.bukkit.material.SpawnEgg;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public final class XItemStack {
    public static final ItemFlag[] ITEM_FLAGS = ItemFlag.values();
    private static final XMaterial DEFAULT_MATERIAL = XMaterial.NETHER_PORTAL;

    private XItemStack() {
    }

    /*
     * WARNING - void declaration
     */
    public static void serialize(@Nonnull ItemStack item, @Nonnull ConfigurationSection config) {
        EnchantmentStorageMeta book;
        Multimap attributes;
        ItemMeta meta;
        Objects.requireNonNull(item, "Cannot serialize a null item");
        Objects.requireNonNull(config, "Cannot serialize item from a null configuration section.");
        config.set("material", (Object)XMaterial.matchXMaterial(item).name());
        if (item.getAmount() > 1) {
            config.set("amount", (Object)item.getAmount());
        }
        if ((meta = item.getItemMeta()) == null) {
            return;
        }
        if (XMaterial.supports(13)) {
            Object damageable;
            if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
                config.set("damage", (Object)damageable.getDamage());
            }
        } else {
            config.set("damage", (Object)item.getDurability());
        }
        if (meta.hasDisplayName()) {
            config.set("name", (Object)meta.getDisplayName());
        }
        if (meta.hasLore()) {
            config.set("lore", (Object)meta.getLore());
        }
        if (XMaterial.supports(14) && meta.hasCustomModelData()) {
            config.set("custom-model-data", (Object)meta.getCustomModelData());
        }
        if (XMaterial.supports(11) && meta.isUnbreakable()) {
            config.set("unbreakable", (Object)true);
        }
        for (Map.Entry entry : meta.getEnchants().entrySet()) {
            String string = "enchants." + XEnchantment.matchXEnchantment((Enchantment)entry.getKey()).name();
            config.set(string, entry.getValue());
        }
        if (!meta.getItemFlags().isEmpty()) {
            Set flags = meta.getItemFlags();
            ArrayList<String> arrayList = new ArrayList<String>(flags.size());
            for (ItemFlag flag : flags) {
                arrayList.add(flag.name());
            }
            config.set("flags", arrayList);
        }
        if (XMaterial.supports(13) && (attributes = meta.getAttributeModifiers()) != null) {
            for (Map.Entry entry : attributes.entries()) {
                String path = "attributes." + ((Attribute)entry.getKey()).name() + '.';
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                config.set(path + "id", (Object)modifier.getUniqueId().toString());
                config.set(path + "name", (Object)modifier.getName());
                config.set(path + "amount", (Object)modifier.getAmount());
                config.set(path + "operation", (Object)modifier.getOperation().name());
                if (modifier.getSlot() == null) continue;
                config.set(path + "slot", (Object)modifier.getSlot().name());
            }
        }
        if (meta instanceof BlockStateMeta) {
            BlockState state = ((BlockStateMeta)meta).getBlockState();
            if (XMaterial.supports(11) && state instanceof ShulkerBox) {
                ShulkerBox shulkerBox = (ShulkerBox)state;
                ConfigurationSection configurationSection = config.createSection("shulker");
                int i = 0;
                for (AttributeModifier itemInBox : shulkerBox.getInventory().getContents()) {
                    if (itemInBox != null) {
                        XItemStack.serialize((ItemStack)itemInBox, configurationSection.createSection(Integer.toString(i)));
                    }
                    ++i;
                }
            } else if (state instanceof CreatureSpawner) {
                CreatureSpawner creatureSpawner = (CreatureSpawner)state;
                config.set("spawner", (Object)creatureSpawner.getSpawnedType().name());
            }
        } else if (meta instanceof EnchantmentStorageMeta) {
            book = (EnchantmentStorageMeta)meta;
            for (Map.Entry entry : book.getStoredEnchants().entrySet()) {
                String entry2 = "stored-enchants." + XEnchantment.matchXEnchantment((Enchantment)entry.getKey()).name();
                config.set(entry2, entry.getValue());
            }
        } else if (meta instanceof SkullMeta) {
            String skull = SkullUtils.getSkinValue(meta);
            if (skull != null) {
                config.set("skull", (Object)skull);
            }
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ConfigurationSection configurationSection = config.createSection("patterns");
            for (Object pattern : banner.getPatterns()) {
                configurationSection.set(pattern.getPattern().name(), (Object)pattern.getColor().name());
            }
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            Color color = leather.getColor();
            config.set("color", (Object)(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue()));
        } else if (meta instanceof PotionMeta) {
            PotionMeta potion;
            if (XMaterial.supports(9)) {
                potion = (PotionMeta)meta;
                List list = potion.getCustomEffects();
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (PotionEffect effect : list) {
                    arrayList.add(effect.getType().getName() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
                }
                config.set("effects", arrayList);
                PotionData potionData = potion.getBasePotionData();
                config.set("base-effect", (Object)(potionData.getType().name() + ", " + potionData.isExtended() + ", " + potionData.isUpgraded()));
                if (potion.hasColor()) {
                    config.set("color", (Object)potion.getColor().asRGB());
                }
            } else if (item.getDurability() != 0) {
                potion = Potion.fromItemStack((ItemStack)item);
                config.set("level", (Object)potion.getLevel());
                config.set("base-effect", (Object)(potion.getType().name() + ", " + potion.hasExtendedDuration() + ", " + potion.isSplash()));
            }
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            config.set("power", (Object)firework.getPower());
            boolean bl = false;
            for (FireworkEffect fw : firework.getEffects()) {
                void var4_16;
                config.set("firework." + (int)var4_16 + ".type", (Object)fw.getType().name());
                ConfigurationSection fwc = config.getConfigurationSection("firework." + (int)var4_16);
                fwc.set("flicker", (Object)fw.hasFlicker());
                fwc.set("trail", (Object)fw.hasTrail());
                List fwBaseColors = fw.getColors();
                List fwFadeColors = fw.getFadeColors();
                ArrayList<String> baseColors = new ArrayList<String>(fwBaseColors.size());
                ArrayList<String> fadeColors = new ArrayList<String>(fwFadeColors.size());
                ConfigurationSection colors = fwc.createSection("colors");
                for (Color color : fwBaseColors) {
                    baseColors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                colors.set("base", baseColors);
                for (Color color : fwFadeColors) {
                    fadeColors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                colors.set("fade", fadeColors);
                ++var4_16;
            }
        } else if (meta instanceof BookMeta) {
            BookMeta.Generation generation;
            book = (BookMeta)meta;
            ConfigurationSection configurationSection = config.createSection("book");
            configurationSection.set("title", (Object)book.getTitle());
            configurationSection.set("author", (Object)book.getAuthor());
            if (XMaterial.supports(9) && (generation = book.getGeneration()) != null) {
                configurationSection.set("generation", (Object)book.getGeneration().toString());
            }
            configurationSection.set("pages", (Object)book.getPages());
        } else if (meta instanceof MapMeta) {
            MapMeta map = (MapMeta)meta;
            ConfigurationSection configurationSection = config.createSection("map");
            configurationSection.set("scaling", (Object)map.isScaling());
            if (XMaterial.supports(11)) {
                if (map.hasLocationName()) {
                    configurationSection.set("location", (Object)map.getLocationName());
                }
                if (map.hasColor()) {
                    Color color = map.getColor();
                    configurationSection.set("color", (Object)(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue()));
                }
            }
            if (XMaterial.supports(14) && map.hasMapView()) {
                MapView mapView = map.getMapView();
                ConfigurationSection view = configurationSection.createSection("view");
                view.set("scale", (Object)mapView.getScale().toString());
                view.set("world", (Object)mapView.getWorld().getName());
                ConfigurationSection centerSection = view.createSection("center");
                centerSection.set("x", (Object)mapView.getCenterX());
                centerSection.set("z", (Object)mapView.getCenterZ());
                view.set("locked", (Object)mapView.isLocked());
                view.set("tracking-position", (Object)mapView.isTrackingPosition());
                view.set("unlimited-tracking", (Object)mapView.isUnlimitedTracking());
            }
        } else if (XMaterial.supports(17)) {
            AxolotlBucketMeta bucket;
            if (meta instanceof AxolotlBucketMeta && (bucket = (AxolotlBucketMeta)meta).hasVariant()) {
                config.set("color", (Object)bucket.getVariant().toString());
            }
        } else if (XMaterial.supports(16)) {
            if (meta instanceof CompassMeta) {
                CompassMeta compass = (CompassMeta)meta;
                ConfigurationSection configurationSection = config.createSection("lodestone");
                configurationSection.set("tracked", (Object)compass.isLodestoneTracked());
                if (compass.hasLodestone()) {
                    Location location = compass.getLodestone();
                    configurationSection.set("location.world", (Object)location.getWorld().getName());
                    configurationSection.set("location.x", (Object)location.getX());
                    configurationSection.set("location.y", (Object)location.getY());
                    configurationSection.set("location.z", (Object)location.getZ());
                }
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                boolean bl = false;
                for (ItemStack projectiles : crossbow.getChargedProjectiles()) {
                    void var4_21;
                    XItemStack.serialize(projectiles, config.getConfigurationSection("projectiles." + (int)var4_21));
                    ++var4_21;
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                config.set("pattern", (Object)tropical.getPattern().name());
                config.set("color", (Object)tropical.getBodyColor().name());
                config.set("pattern-color", (Object)tropical.getPatternColor().name());
            } else if (meta instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
                List list = stew.getCustomEffects();
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (PotionEffect effect : list) {
                    arrayList.add(effect.getType().getName() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
                }
                config.set("effects", arrayList);
            }
        } else if (!XMaterial.supports(13)) {
            if (XMaterial.supports(11)) {
                if (meta instanceof SpawnEggMeta) {
                    SpawnEggMeta spawnEgg = (SpawnEggMeta)meta;
                    config.set("creature", (Object)spawnEgg.getSpawnedType().getName());
                }
            } else {
                MaterialData data = item.getData();
                if (data instanceof SpawnEgg) {
                    SpawnEgg spawnEgg = (SpawnEgg)data;
                    config.set("creature", (Object)spawnEgg.getSpawnedType().getName());
                }
            }
        }
    }

    public static boolean isDefaultItem(ItemStack item) {
        return DEFAULT_MATERIAL.isSimilar(item);
    }

    public static Map<String, Object> serialize(@Nonnull ItemStack item) {
        Objects.requireNonNull(item, "Cannot serialize a null item");
        MemoryConfiguration config = new MemoryConfiguration();
        XItemStack.serialize(item, (ConfigurationSection)config);
        return XItemStack.configSectionToMap((ConfigurationSection)config);
    }

    @Nonnull
    public static ItemStack deserialize(@Nonnull ConfigurationSection config) {
        return XItemStack.edit(new ItemStack(DEFAULT_MATERIAL.parseMaterial()), config, Function.identity(), null);
    }

    private static List<String> splitNewLine(String str) {
        int len = str.length();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == '\n') {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, i));
        }
        return list;
    }

    @Nonnull
    public static ItemStack deserialize(@Nonnull ConfigurationSection config, @Nonnull Function<String, String> translator) {
        return XItemStack.deserialize(config, translator, null);
    }

    @Nonnull
    public static ItemStack deserialize(@Nonnull ConfigurationSection config, @Nonnull Function<String, String> translator, @Nullable Consumer<Exception> restart) {
        return XItemStack.edit(new ItemStack(DEFAULT_MATERIAL.parseMaterial()), config, translator, restart);
    }

    @Nonnull
    public static ItemStack deserialize(@Nonnull Map<String, Object> serializedItem, @Nonnull Function<String, String> translator) {
        Objects.requireNonNull(serializedItem, "serializedItem cannot be null.");
        Objects.requireNonNull(translator, "translator cannot be null.");
        return XItemStack.deserialize(XItemStack.mapToConfigSection(serializedItem), translator);
    }

    private static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private static List<String> split(@Nonnull String str, char separatorChar) {
        ArrayList<String> list = new ArrayList<String>(5);
        boolean match = false;
        boolean lastMatch = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = i + 1;
                continue;
            }
            lastMatch = false;
            match = true;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, len));
        }
        return list;
    }

    @Nonnull
    public static ItemStack edit(@Nonnull ItemStack item, @Nonnull ConfigurationSection config, @Nonnull Function<String, String> translator, @Nullable Consumer<Exception> restart) {
        ConfigurationSection attributes;
        List flags;
        ConfigurationSection enchantment;
        ConfigurationSection enchants;
        int modelData;
        ItemMeta tempMeta;
        int amount;
        Objects.requireNonNull(item, "Cannot operate on null ItemStack, considering using an AIR ItemStack instead");
        Objects.requireNonNull(config, "Cannot deserialize item to a null configuration section.");
        Objects.requireNonNull(translator, "Translator function cannot be null");
        String materialName = config.getString("material");
        if (!Strings.isNullOrEmpty((String)materialName)) {
            UnAcceptableMaterialCondition unsupportedMaterialCondition;
            XMaterial material;
            Optional<XMaterial> materialOpt = XMaterial.matchXMaterial(materialName);
            if (materialOpt.isPresent()) {
                material = materialOpt.get();
            } else {
                UnknownMaterialCondition unknownMaterialCondition = new UnknownMaterialCondition(materialName);
                if (restart == null) {
                    throw unknownMaterialCondition;
                }
                restart.accept(unknownMaterialCondition);
                if (unknownMaterialCondition.hasSolution()) {
                    material = unknownMaterialCondition.solution;
                } else {
                    throw unknownMaterialCondition;
                }
            }
            if (!material.isSupported()) {
                unsupportedMaterialCondition = new UnAcceptableMaterialCondition(material, UnAcceptableMaterialCondition.Reason.UNSUPPORTED);
                if (restart == null) {
                    throw unsupportedMaterialCondition;
                }
                restart.accept(unsupportedMaterialCondition);
                if (unsupportedMaterialCondition.hasSolution()) {
                    material = unsupportedMaterialCondition.solution;
                } else {
                    throw unsupportedMaterialCondition;
                }
            }
            if (XTag.INVENTORY_NOT_DISPLAYABLE.isTagged(material)) {
                unsupportedMaterialCondition = new UnAcceptableMaterialCondition(material, UnAcceptableMaterialCondition.Reason.NOT_DISPLAYABLE);
                if (restart == null) {
                    throw unsupportedMaterialCondition;
                }
                restart.accept(unsupportedMaterialCondition);
                if (unsupportedMaterialCondition.hasSolution()) {
                    material = unsupportedMaterialCondition.solution;
                } else {
                    throw unsupportedMaterialCondition;
                }
            }
            material.setType(item);
        }
        if ((amount = config.getInt("amount")) > 1) {
            item.setAmount(amount);
        }
        ItemMeta meta = (tempMeta = item.getItemMeta()) == null ? Bukkit.getItemFactory().getItemMeta(XMaterial.STONE.parseMaterial()) : tempMeta;
        if (XMaterial.supports(13)) {
            int damage;
            if (meta instanceof Damageable && (damage = config.getInt("damage")) > 0) {
                ((Damageable)meta).setDamage(damage);
            }
        } else {
            int damage = config.getInt("damage");
            if (damage > 0) {
                item.setDurability((short)damage);
            }
        }
        if (meta instanceof SkullMeta) {
            String skull = config.getString("skull");
            if (skull != null) {
                SkullUtils.applySkin(meta, skull);
            }
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ConfigurationSection patterns = config.getConfigurationSection("patterns");
            if (patterns != null) {
                for (String pattern : patterns.getKeys(false)) {
                    PatternType type = PatternType.getByIdentifier((String)pattern);
                    if (type == null) {
                        type = (PatternType)Enums.getIfPresent(PatternType.class, (String)pattern.toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                    }
                    DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patterns.getString(pattern).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                    banner.addPattern(new Pattern(color, type));
                }
            }
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            String colorStr = config.getString("color");
            if (colorStr != null) {
                leather.setColor(XItemStack.parseColor(colorStr));
            }
        } else if (meta instanceof PotionMeta) {
            List<String> split;
            String baseEffect;
            if (XMaterial.supports(9)) {
                PotionMeta potion = (PotionMeta)meta;
                for (String effects : config.getStringList("effects")) {
                    XPotion.Effect effect = XPotion.parseEffect(effects);
                    if (!effect.hasChance()) continue;
                    potion.addCustomEffect(effect.getEffect(), true);
                }
                baseEffect = config.getString("base-effect");
                if (!Strings.isNullOrEmpty((String)baseEffect)) {
                    split = XItemStack.split(baseEffect, ',');
                    PotionType type = (PotionType)Enums.getIfPresent(PotionType.class, (String)split.get(0).trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.UNCRAFTABLE);
                    boolean extended = split.size() != 1 && Boolean.parseBoolean(split.get(1).trim());
                    boolean upgraded = split.size() > 2 && Boolean.parseBoolean(split.get(2).trim());
                    PotionData potionData = new PotionData(type, extended, upgraded);
                    potion.setBasePotionData(potionData);
                }
                if (config.contains("color")) {
                    potion.setColor(Color.fromRGB((int)config.getInt("color")));
                }
            } else if (config.contains("level")) {
                int level = config.getInt("level");
                baseEffect = config.getString("base-effect");
                if (!Strings.isNullOrEmpty((String)baseEffect)) {
                    split = XItemStack.split(baseEffect, ',');
                    PotionType type = (PotionType)Enums.getIfPresent(PotionType.class, (String)split.get(0).trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.SLOWNESS);
                    boolean extended = split.size() != 1 && Boolean.parseBoolean(split.get(1).trim());
                    boolean splash = split.size() > 2 && Boolean.parseBoolean(split.get(2).trim());
                    item = new Potion(type, level, splash, extended).toItemStack(1);
                }
            }
        } else if (meta instanceof BlockStateMeta) {
            BlockStateMeta bsm = (BlockStateMeta)meta;
            BlockState state = bsm.getBlockState();
            if (state instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)state;
                spawner.setSpawnedType((EntityType)Enums.getIfPresent(EntityType.class, (String)config.getString("spawner").toUpperCase(Locale.ENGLISH)).orNull());
                spawner.update(true);
                bsm.setBlockState((BlockState)spawner);
            } else if (XMaterial.supports(11) && state instanceof ShulkerBox) {
                ConfigurationSection shulkerSection = config.getConfigurationSection("contents");
                if (shulkerSection != null) {
                    ShulkerBox box = (ShulkerBox)state;
                    for (String key : shulkerSection.getKeys(false)) {
                        ItemStack boxItem = XItemStack.deserialize(shulkerSection.getConfigurationSection(key));
                        int slot = XItemStack.toInt(key, 0);
                        box.getInventory().setItem(slot, boxItem);
                    }
                    box.update(true);
                    bsm.setBlockState((BlockState)box);
                }
            } else if (state instanceof Banner) {
                Banner banner = (Banner)state;
                ConfigurationSection patterns = config.getConfigurationSection("patterns");
                if (!XMaterial.supports(14)) {
                    banner.setBaseColor(DyeColor.WHITE);
                }
                if (patterns != null) {
                    for (String pattern : patterns.getKeys(false)) {
                        PatternType type = PatternType.getByIdentifier((String)pattern);
                        if (type == null) {
                            type = (PatternType)Enums.getIfPresent(PatternType.class, (String)pattern.toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                        }
                        DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patterns.getString(pattern).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                        banner.addPattern(new Pattern(color, type));
                    }
                    banner.update(true);
                    bsm.setBlockState((BlockState)banner);
                }
            }
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            firework.setPower(config.getInt("power"));
            ConfigurationSection fireworkSection = config.getConfigurationSection("firework");
            if (fireworkSection != null) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                for (String fws : fireworkSection.getKeys(false)) {
                    ConfigurationSection fw = config.getConfigurationSection("firework." + fws);
                    builder.flicker(fw.getBoolean("flicker"));
                    builder.trail(fw.getBoolean("trail"));
                    builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fw.getString("type").toUpperCase(Locale.ENGLISH)).or((Object)FireworkEffect.Type.STAR));
                    ConfigurationSection colorsSection = fw.getConfigurationSection("colors");
                    List fwColors = colorsSection.getStringList("base");
                    ArrayList<Color> colors = new ArrayList<Color>(fwColors.size());
                    for (String colorStr : fwColors) {
                        colors.add(XItemStack.parseColor(colorStr));
                    }
                    builder.withColor(colors);
                    fwColors = colorsSection.getStringList("fade");
                    colors = new ArrayList(fwColors.size());
                    for (String colorStr : fwColors) {
                        colors.add(XItemStack.parseColor(colorStr));
                    }
                    builder.withFade(colors);
                    firework.addEffect(builder.build());
                }
            }
        } else if (meta instanceof BookMeta) {
            BookMeta book = (BookMeta)meta;
            ConfigurationSection bookInfo = config.getConfigurationSection("book");
            if (bookInfo != null) {
                String generationValue;
                book.setTitle(bookInfo.getString("title"));
                book.setAuthor(bookInfo.getString("author"));
                book.setPages(bookInfo.getStringList("pages"));
                if (XMaterial.supports(9) && (generationValue = bookInfo.getString("generation")) != null) {
                    BookMeta.Generation generation = (BookMeta.Generation)Enums.getIfPresent(BookMeta.Generation.class, (String)generationValue).orNull();
                    book.setGeneration(generation);
                }
            }
        } else if (meta instanceof MapMeta) {
            MapMeta map = (MapMeta)meta;
            ConfigurationSection mapSection = config.getConfigurationSection("map");
            if (mapSection != null) {
                World world;
                ConfigurationSection view;
                map.setScaling(mapSection.getBoolean("scaling"));
                if (XMaterial.supports(11)) {
                    if (mapSection.isSet("location")) {
                        map.setLocationName(mapSection.getString("location"));
                    }
                    if (mapSection.isSet("color")) {
                        Color color = XItemStack.parseColor(mapSection.getString("color"));
                        map.setColor(color);
                    }
                }
                if (XMaterial.supports(14) && (view = mapSection.getConfigurationSection("view")) != null && (world = Bukkit.getWorld((String)view.getString("world"))) != null) {
                    MapView mapView = Bukkit.createMap((World)world);
                    mapView.setWorld(world);
                    mapView.setScale((MapView.Scale)Enums.getIfPresent(MapView.Scale.class, (String)view.getString("scale")).or((Object)MapView.Scale.NORMAL));
                    mapView.setLocked(view.getBoolean("locked"));
                    mapView.setTrackingPosition(view.getBoolean("tracking-position"));
                    mapView.setUnlimitedTracking(view.getBoolean("unlimited-tracking"));
                    ConfigurationSection centerSection = view.getConfigurationSection("center");
                    mapView.setCenterX(centerSection.getInt("x"));
                    mapView.setCenterZ(centerSection.getInt("z"));
                    map.setMapView(mapView);
                }
            }
        } else if (XMaterial.supports(17)) {
            if (meta instanceof AxolotlBucketMeta) {
                AxolotlBucketMeta bucket = (AxolotlBucketMeta)meta;
                String variantStr = config.getString("color");
                if (variantStr != null) {
                    Axolotl.Variant variant = (Axolotl.Variant)Enums.getIfPresent(Axolotl.Variant.class, (String)variantStr.toUpperCase(Locale.ENGLISH)).or((Object)Axolotl.Variant.BLUE);
                    bucket.setVariant(variant);
                }
            }
        } else if (XMaterial.supports(16)) {
            if (meta instanceof CompassMeta) {
                CompassMeta compass = (CompassMeta)meta;
                compass.setLodestoneTracked(config.getBoolean("tracked"));
                ConfigurationSection lodestone = config.getConfigurationSection("lodestone");
                if (lodestone != null) {
                    World world = Bukkit.getWorld((String)lodestone.getString("world"));
                    double x = lodestone.getDouble("x");
                    double y = lodestone.getDouble("y");
                    double z = lodestone.getDouble("z");
                    compass.setLodestone(new Location(world, x, y, z));
                }
            }
        } else if (XMaterial.supports(15)) {
            if (meta instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
                for (String effects : config.getStringList("effects")) {
                    XPotion.Effect effect = XPotion.parseEffect(effects);
                    if (!effect.hasChance()) continue;
                    stew.addCustomEffect(effect.getEffect(), true);
                }
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                for (String projectiles : config.getConfigurationSection("projectiles").getKeys(false)) {
                    ItemStack projectile = XItemStack.deserialize(config.getConfigurationSection("projectiles." + projectiles));
                    crossbow.addChargedProjectile(projectile);
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.WHITE);
                DyeColor patternColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("pattern-color")).or((Object)DyeColor.WHITE);
                TropicalFish.Pattern pattern = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)config.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY);
                tropical.setBodyColor(color);
                tropical.setPatternColor(patternColor);
                tropical.setPattern(pattern);
            }
        } else if (!XMaterial.supports(13)) {
            if (XMaterial.supports(11)) {
                String creatureName;
                if (meta instanceof SpawnEggMeta && !Strings.isNullOrEmpty((String)(creatureName = config.getString("creature")))) {
                    SpawnEggMeta spawnEgg = (SpawnEggMeta)meta;
                    com.google.common.base.Optional creature = Enums.getIfPresent(EntityType.class, (String)creatureName.toUpperCase(Locale.ENGLISH));
                    if (creature.isPresent()) {
                        spawnEgg.setSpawnedType((EntityType)creature.get());
                    }
                }
            } else {
                String creatureName;
                MaterialData data = item.getData();
                if (data instanceof SpawnEgg && !Strings.isNullOrEmpty((String)(creatureName = config.getString("creature")))) {
                    SpawnEgg spawnEgg = (SpawnEgg)data;
                    com.google.common.base.Optional creature = Enums.getIfPresent(EntityType.class, (String)creatureName.toUpperCase(Locale.ENGLISH));
                    if (creature.isPresent()) {
                        spawnEgg.setSpawnedType((EntityType)creature.get());
                    }
                    item.setData(data);
                }
            }
        }
        String name = config.getString("name");
        if (!Strings.isNullOrEmpty((String)name)) {
            String translated = translator.apply(name);
            meta.setDisplayName(translated);
        } else if (name != null && name.isEmpty()) {
            meta.setDisplayName(" ");
        }
        if (XMaterial.supports(11)) {
            meta.setUnbreakable(config.getBoolean("unbreakable"));
        }
        if (XMaterial.supports(14) && (modelData = config.getInt("custom-model-data")) != 0) {
            meta.setCustomModelData(Integer.valueOf(modelData));
        }
        if (config.isSet("lore")) {
            ArrayList<String> translatedLore;
            List lores = config.getStringList("lore");
            if (!lores.isEmpty()) {
                translatedLore = new ArrayList<String>(lores.size());
                Iterator creature = lores.iterator();
                while (creature.hasNext()) {
                    String lore = (String)creature.next();
                    if (lore.isEmpty()) {
                        translatedLore.add(" ");
                        continue;
                    }
                    for (String singleLore : XItemStack.splitNewLine(lore)) {
                        if (singleLore.isEmpty()) {
                            translatedLore.add(" ");
                            continue;
                        }
                        translatedLore.add(translator.apply(singleLore));
                    }
                }
            } else {
                String lore = config.getString("lore");
                translatedLore = new ArrayList(10);
                if (!Strings.isNullOrEmpty((String)lore)) {
                    for (String singleLore : XItemStack.splitNewLine(lore)) {
                        if (singleLore.isEmpty()) {
                            translatedLore.add(" ");
                            continue;
                        }
                        translatedLore.add(translator.apply(singleLore));
                    }
                }
            }
            meta.setLore(translatedLore);
        }
        if ((enchants = config.getConfigurationSection("enchants")) != null) {
            for (String ench : enchants.getKeys(false)) {
                Optional<XEnchantment> enchant = XEnchantment.matchXEnchantment(ench);
                enchant.ifPresent(xEnchantment -> meta.addEnchant(xEnchantment.getEnchant(), enchants.getInt(ench), true));
            }
        } else if (config.getBoolean("glow")) {
            meta.addEnchant(XEnchantment.DURABILITY.getEnchant(), 1, false);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if ((enchantment = config.getConfigurationSection("stored-enchants")) != null) {
            for (String ench : enchantment.getKeys(false)) {
                Optional<XEnchantment> enchant = XEnchantment.matchXEnchantment(ench);
                EnchantmentStorageMeta book = (EnchantmentStorageMeta)meta;
                enchant.ifPresent(xEnchantment -> book.addStoredEnchant(xEnchantment.getEnchant(), enchantment.getInt(ench), true));
            }
        }
        if (!(flags = config.getStringList("flags")).isEmpty()) {
            for (String flag : flags) {
                if ((flag = flag.toUpperCase(Locale.ENGLISH)).equals("ALL")) {
                    meta.addItemFlags(ITEM_FLAGS);
                    break;
                }
                ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)flag).orNull();
                if (itemFlag == null) continue;
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
        } else {
            String allFlags = config.getString("flags");
            if (!Strings.isNullOrEmpty((String)allFlags) && allFlags.equalsIgnoreCase("ALL")) {
                meta.addItemFlags(ITEM_FLAGS);
            }
        }
        if (XMaterial.supports(13) && (attributes = config.getConfigurationSection("attributes")) != null) {
            for (String attribute : attributes.getKeys(false)) {
                ConfigurationSection section;
                Attribute attributeInst = (Attribute)Enums.getIfPresent(Attribute.class, (String)attribute.toUpperCase(Locale.ENGLISH)).orNull();
                if (attributeInst == null || (section = attributes.getConfigurationSection(attribute)) == null) continue;
                String attribId = section.getString("id");
                UUID id = attribId != null ? UUID.fromString(attribId) : UUID.randomUUID();
                EquipmentSlot slot = section.getString("slot") != null ? (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)section.getString("slot")).or((Object)EquipmentSlot.HAND) : null;
                AttributeModifier modifier = new AttributeModifier(id, section.getString("name"), (double)section.getInt("amount"), (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)section.getString("operation")).or((Object)AttributeModifier.Operation.ADD_NUMBER), slot);
                meta.addAttributeModifier(attributeInst, modifier);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    @Nonnull
    public static ItemStack deserialize(@Nonnull Map<String, Object> serializedItem) {
        Objects.requireNonNull(serializedItem, "serializedItem cannot be null.");
        return XItemStack.deserialize(XItemStack.mapToConfigSection(serializedItem));
    }

    @Nonnull
    private static ConfigurationSection mapToConfigSection(@Nonnull Map<?, ?> map) {
        MemoryConfiguration config = new MemoryConfiguration();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Map) {
                value = XItemStack.mapToConfigSection((Map)value);
            }
            config.set(key, value);
        }
        return config;
    }

    @Nonnull
    private static Map<String, Object> configSectionToMap(@Nonnull ConfigurationSection config) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : config.getKeys(false)) {
            Map<String, Object> value = config.get(key);
            if (value == null) continue;
            if (value instanceof ConfigurationSection) {
                value = XItemStack.configSectionToMap((ConfigurationSection)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @Nonnull
    public static Color parseColor(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return Color.BLACK;
        }
        List<String> rgb = XItemStack.split(str.replace(" ", ""), ',');
        if (rgb.size() < 3) {
            return Color.WHITE;
        }
        return Color.fromRGB((int)XItemStack.toInt(rgb.get(0), 0), (int)XItemStack.toInt(rgb.get(1), 0), (int)XItemStack.toInt(rgb.get(2), 0));
    }

    @Nonnull
    public static List<ItemStack> giveOrDrop(@Nonnull Player player, ItemStack ... items) {
        return XItemStack.giveOrDrop(player, false, items);
    }

    @Nonnull
    public static List<ItemStack> giveOrDrop(@Nonnull Player player, boolean split, ItemStack ... items) {
        if (items == null || items.length == 0) {
            return new ArrayList<ItemStack>();
        }
        List<ItemStack> leftOvers = XItemStack.addItems((Inventory)player.getInventory(), split, items);
        World world = player.getWorld();
        Location location = player.getLocation();
        for (ItemStack drop : leftOvers) {
            world.dropItemNaturally(location, drop);
        }
        return leftOvers;
    }

    public static List<ItemStack> addItems(@Nonnull Inventory inventory, boolean split, ItemStack ... items) {
        return XItemStack.addItems(inventory, split, null, items);
    }

    @Nonnull
    public static List<ItemStack> addItems(@Nonnull Inventory inventory, boolean split, @Nullable Predicate<Integer> modifiableSlots, ItemStack ... items) {
        Objects.requireNonNull(inventory, "Cannot add items to null inventory");
        Objects.requireNonNull(items, "Cannot add null items to inventory");
        ArrayList<ItemStack> leftOvers = new ArrayList<ItemStack>(items.length);
        int invSize = inventory.getStorageContents().length;
        int lastEmpty = 0;
        block0: for (ItemStack item : items) {
            int lastPartial = 0;
            while (true) {
                int firstPartial;
                int n = firstPartial = lastPartial >= invSize ? -1 : XItemStack.firstPartial(inventory, item, lastPartial, modifiableSlots);
                if (firstPartial == -1) {
                    if (lastEmpty != -1) {
                        lastEmpty = XItemStack.firstEmpty(inventory, lastEmpty, modifiableSlots);
                    }
                    if (lastEmpty == -1) {
                        leftOvers.add(item);
                        continue block0;
                    }
                    lastPartial = invSize + 1;
                    int maxSize = split ? item.getMaxStackSize() : inventory.getMaxStackSize();
                    int amount = item.getAmount();
                    if (amount <= maxSize) {
                        inventory.setItem(lastEmpty, item);
                        continue block0;
                    }
                    ItemStack copy = item.clone();
                    copy.setAmount(maxSize);
                    inventory.setItem(lastEmpty, copy);
                    item.setAmount(amount - maxSize);
                    if (++lastEmpty != invSize) continue;
                    lastEmpty = -1;
                    continue;
                }
                ItemStack partialItem = inventory.getItem(firstPartial);
                int maxAmount = split ? partialItem.getMaxStackSize() : inventory.getMaxStackSize();
                int partialAmount = partialItem.getAmount();
                int amount = item.getAmount();
                int sum = amount + partialAmount;
                if (sum <= maxAmount) {
                    partialItem.setAmount(sum);
                    inventory.setItem(firstPartial, partialItem);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                inventory.setItem(firstPartial, partialItem);
                item.setAmount(sum - maxAmount);
                lastPartial = firstPartial + 1;
            }
        }
        return leftOvers;
    }

    public static int firstPartial(@Nonnull Inventory inventory, @Nullable ItemStack item, int beginIndex) {
        return XItemStack.firstPartial(inventory, item, beginIndex, null);
    }

    public static int firstPartial(@Nonnull Inventory inventory, @Nullable ItemStack item, int beginIndex, @Nullable Predicate<Integer> modifiableSlots) {
        if (item != null) {
            ItemStack[] items = inventory.getStorageContents();
            int invSize = items.length;
            if (beginIndex < 0 || beginIndex >= invSize) {
                throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Inventory storage content size: " + invSize);
            }
            while (beginIndex < invSize) {
                ItemStack cItem;
                if ((modifiableSlots == null || modifiableSlots.test(beginIndex)) && (cItem = items[beginIndex]) != null && cItem.getAmount() < cItem.getMaxStackSize() && cItem.isSimilar(item)) {
                    return beginIndex;
                }
                ++beginIndex;
            }
        }
        return -1;
    }

    public static List<ItemStack> stack(@Nonnull Collection<ItemStack> items) {
        return XItemStack.stack(items, ItemStack::isSimilar);
    }

    @Nonnull
    public static List<ItemStack> stack(@Nonnull Collection<ItemStack> items, @Nonnull BiPredicate<ItemStack, ItemStack> similarity) {
        Objects.requireNonNull(items, "Cannot stack null items");
        Objects.requireNonNull(similarity, "Similarity check cannot be null");
        ArrayList<ItemStack> stacked = new ArrayList<ItemStack>(items.size());
        for (ItemStack item : items) {
            if (item == null) continue;
            boolean add = true;
            for (ItemStack stack : stacked) {
                if (!similarity.test(item, stack)) continue;
                stack.setAmount(stack.getAmount() + item.getAmount());
                add = false;
                break;
            }
            if (!add) continue;
            stacked.add(item.clone());
        }
        return stacked;
    }

    public static int firstEmpty(@Nonnull Inventory inventory, int beginIndex) {
        return XItemStack.firstEmpty(inventory, beginIndex, null);
    }

    public static int firstEmpty(@Nonnull Inventory inventory, int beginIndex, @Nullable Predicate<Integer> modifiableSlots) {
        ItemStack[] items = inventory.getStorageContents();
        int invSize = items.length;
        if (beginIndex < 0 || beginIndex >= invSize) {
            throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Inventory storage content size: " + invSize);
        }
        while (beginIndex < invSize) {
            if ((modifiableSlots == null || modifiableSlots.test(beginIndex)) && items[beginIndex] == null) {
                return beginIndex;
            }
            ++beginIndex;
        }
        return -1;
    }

    public static int firstPartialOrEmpty(@Nonnull Inventory inventory, @Nullable ItemStack item, int beginIndex) {
        if (item != null) {
            ItemStack[] items = inventory.getStorageContents();
            int len = items.length;
            if (beginIndex < 0 || beginIndex >= len) {
                throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Size: " + len);
            }
            while (beginIndex < len) {
                ItemStack cItem = items[beginIndex];
                if (cItem == null || cItem.getAmount() < cItem.getMaxStackSize() && cItem.isSimilar(item)) {
                    return beginIndex;
                }
                ++beginIndex;
            }
        }
        return -1;
    }

    public static final class UnknownMaterialCondition
    extends MaterialCondition {
        private final String material;

        public UnknownMaterialCondition(String material) {
            super("Unknown material: " + material);
            this.material = material;
        }

        public String getMaterial() {
            return this.material;
        }
    }

    public static final class UnAcceptableMaterialCondition
    extends MaterialCondition {
        private final XMaterial material;
        private final Reason reason;

        public UnAcceptableMaterialCondition(XMaterial material, Reason reason) {
            super("Unacceptable material: " + material.name() + " (" + reason.name() + ')');
            this.material = material;
            this.reason = reason;
        }

        public Reason getReason() {
            return this.reason;
        }

        public XMaterial getMaterial() {
            return this.material;
        }

        public static enum Reason {
            UNSUPPORTED,
            NOT_DISPLAYABLE;

        }
    }

    public static class MaterialCondition
    extends RuntimeException {
        protected XMaterial solution;

        public MaterialCondition(String message) {
            super(message);
        }

        public void setSolution(XMaterial solution) {
            this.solution = solution;
        }

        public boolean hasSolution() {
            return this.solution != null;
        }
    }
}

