/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import java.util.Optional;
import java.util.Random;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.Game;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;

class Taunt {
    private String tauntPlayer;
    private int delay = Config.tauntDelay;
    private boolean running;

    protected void update() {
        if (this.delay == 0) {
            if (this.running) {
                this.launchTaunt();
            } else if (Config.tauntLast || Board.sizeHider() > 1) {
                this.executeTaunt();
            }
        } else {
            --this.delay;
            this.delay = Math.max(this.delay, 0);
        }
    }

    private void executeTaunt() {
        Optional rand = Board.getHiders().stream().skip(new Random().nextInt(Board.size())).findFirst();
        if (!rand.isPresent()) {
            Main.plugin.getLogger().warning("Failed to select random seeker.");
            return;
        }
        Player taunted = (Player)rand.get();
        taunted.sendMessage(Localization.message("TAUNTED").toString());
        Game.broadcastMessage(Config.tauntPrefix + Localization.message("TAUNT"));
        this.tauntPlayer = taunted.getName();
        this.running = true;
        this.delay = 30;
    }

    private void launchTaunt() {
        Player taunted = Board.getPlayer(this.tauntPlayer);
        if (taunted != null) {
            if (!Board.isHider(taunted)) {
                Main.plugin.getLogger().info("Taunted played died and is now seeker. Skipping taunt.");
                this.tauntPlayer = "";
                this.running = false;
                this.delay = Config.tauntDelay;
                return;
            }
            World world = taunted.getLocation().getWorld();
            if (world == null) {
                Main.plugin.getLogger().severe("Game world is null while trying to launch taunt.");
                this.tauntPlayer = "";
                this.running = false;
                this.delay = Config.tauntDelay;
                return;
            }
            Firework fw = (Firework)world.spawnEntity(taunted.getLocation(), EntityType.FIREWORK);
            FireworkMeta fwm = fw.getFireworkMeta();
            fwm.setPower(4);
            fwm.addEffect(FireworkEffect.builder().withColor(Color.BLUE).withColor(Color.RED).withColor(Color.YELLOW).with(FireworkEffect.Type.STAR).with(FireworkEffect.Type.BALL).with(FireworkEffect.Type.BALL_LARGE).flicker(true).withTrail().build());
            fw.setFireworkMeta(fwm);
            Game.broadcastMessage(Config.tauntPrefix + Localization.message("TAUNT_ACTIVATE"));
        }
        this.tauntPlayer = "";
        this.running = false;
        this.delay = Config.tauntDelay;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.running;
    }
}

