/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.util.Packet;
import org.bukkit.entity.Player;

class Glow {
    private int glowTime = 0;
    private boolean running;

    public void onProjectile() {
        this.glowTime = Config.glowStackable ? (this.glowTime += Config.glowLength) : Config.glowLength;
        if (!this.running) {
            this.startGlow();
        }
    }

    private void startGlow() {
        this.running = true;
        for (Player hider : Board.getHiders()) {
            for (Player seeker : Board.getSeekers()) {
                Packet.setGlow(hider, seeker, true);
            }
        }
    }

    protected void update() {
        if (this.running) {
            --this.glowTime;
            this.glowTime = Math.max(this.glowTime, 0);
            if (this.glowTime == 0) {
                this.stopGlow();
            }
        }
    }

    private void stopGlow() {
        this.running = false;
        for (Player hider : Board.getHiders()) {
            for (Player seeker : Board.getSeekers()) {
                Packet.setGlow(hider, seeker, false);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

