/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Items;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.database.Database;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.Border;
import net.tylermurphy.hideAndSeek.game.EventListener;
import net.tylermurphy.hideAndSeek.game.Glow;
import net.tylermurphy.hideAndSeek.game.Taunt;
import net.tylermurphy.hideAndSeek.util.Packet;
import net.tylermurphy.hideAndSeek.util.Status;
import net.tylermurphy.hideAndSeek.util.WinType;
import net.tylermurphy.hideAndSeek.world.WorldLoader;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Game {
    public static Taunt taunt;
    public static Glow glow;
    public static Border worldBorder;
    public static WorldLoader worldLoader;
    public static int tick;
    public static int countdownTime;
    public static int gameId;
    public static int timeLeft;
    public static Status status;

    public static void start(Player seeker) {
        if (status == Status.STARTING || status == Status.PLAYING) {
            return;
        }
        if (worldLoader.getWorld() != null) {
            worldLoader.rollback();
        } else {
            worldLoader.loadMap();
        }
        Board.reload();
        for (Player temp : Board.getPlayers()) {
            if (temp.getName().equals(seeker.getName())) continue;
            Board.addHider(temp);
        }
        Board.addSeeker(seeker);
        Config.currentWorldborderSize = Config.worldborderSize;
        for (Player player : Board.getPlayers()) {
            player.getInventory().clear();
            player.setGameMode(GameMode.ADVENTURE);
            player.teleport(new Location(Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld)), Config.spawnPosition.getX(), Config.spawnPosition.getY(), Config.spawnPosition.getZ()));
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
        }
        for (Player player : Board.getSeekers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 1000000, 127, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 1000000, 127, false, false));
            player.sendTitle(ChatColor.RED + "" + ChatColor.BOLD + "SEEKER", ChatColor.WHITE + Localization.message("SEEKERS_SUBTITLE").toString(), 10, 70, 20);
        }
        for (Player player : Board.getHiders()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 1000000, 5, false, false));
            player.sendTitle(ChatColor.GOLD + "" + ChatColor.BOLD + "HIDER", ChatColor.WHITE + Localization.message("HIDERS_SUBTITLE").toString(), 10, 70, 20);
        }
        if (Config.tauntEnabled) {
            taunt = new Taunt();
        }
        if (Config.glowEnabled) {
            glow = new Glow();
        }
        worldBorder = new Border();
        worldBorder.resetWorldborder("hideandseek_" + Config.spawnWorld);
        if (Config.gameLength > 0) {
            timeLeft = Config.gameLength;
        }
        for (Player player : Board.getPlayers()) {
            Board.createGameBoard(player);
        }
        Board.reloadGameBoards();
        status = Status.STARTING;
        int temp = gameId;
        Game.broadcastMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(30));
        Game.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(20), gameId, 200);
        Game.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(10), gameId, 400);
        Game.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(5), gameId, 500);
        Game.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(3), gameId, 540);
        Game.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(2), gameId, 560);
        Game.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(1), gameId, 580);
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)Main.plugin, () -> {
            if (temp != gameId) {
                return;
            }
            Game.broadcastMessage(Config.messagePrefix + Localization.message("START"));
            for (Player player : Board.getPlayers()) {
                Game.resetPlayer(player);
            }
            status = Status.PLAYING;
        }, 600L);
    }

    public static void stop(WinType type) {
        List<Object> winners;
        if (status == Status.STANDBY) {
            return;
        }
        tick = 0;
        countdownTime = -1;
        status = Status.STANDBY;
        ++gameId;
        timeLeft = 0;
        List<UUID> players = Board.getPlayers().stream().map(Entity::getUniqueId).collect(Collectors.toList());
        if (type == WinType.HIDER_WIN) {
            winners = Board.getHiders().stream().map(Entity::getUniqueId).collect(Collectors.toList());
            Database.playerInfo.addWins(players, winners, type);
        } else if (type == WinType.SEEKER_WIN) {
            winners = new ArrayList();
            winners.add(Board.getFirstSeeker().getUniqueId());
            Database.playerInfo.addWins(players, winners, type);
        }
        worldBorder.resetWorldborder("hideandseek_" + Config.spawnWorld);
        for (Player player : Board.getPlayers()) {
            Board.createLobbyBoard(player);
            player.setGameMode(GameMode.ADVENTURE);
            Board.addHider(player);
            player.getInventory().clear();
            player.teleport(new Location(Bukkit.getWorld((String)Config.lobbyWorld), Config.lobbyPosition.getX(), Config.lobbyPosition.getY(), Config.lobbyPosition.getZ()));
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, 100));
            for (Player temp : Board.getPlayers()) {
                Packet.setGlow(player, temp, false);
            }
        }
        EventListener.temp_loc.clear();
        worldLoader.unloadMap();
        Board.reloadLobbyBoards();
    }

    public static boolean isNotSetup() {
        if (Config.spawnPosition.getBlockX() == 0 && Config.spawnPosition.getBlockY() == 0 && Config.spawnPosition.getBlockZ() == 0) {
            return true;
        }
        if (Config.lobbyPosition.getBlockX() == 0 && Config.lobbyPosition.getBlockY() == 0 && Config.lobbyPosition.getBlockZ() == 0) {
            return true;
        }
        if (Config.exitPosition.getBlockX() == 0 && Config.exitPosition.getBlockY() == 0 && Config.exitPosition.getBlockZ() == 0) {
            return true;
        }
        File destenation = new File(Main.root + File.separator + "hideandseek_" + Config.spawnWorld);
        if (!destenation.exists()) {
            return true;
        }
        return Config.saveMinX == 0 || Config.saveMinZ == 0 || Config.saveMaxX == 0 || Config.saveMaxZ == 0;
    }

    public static void onTick() {
        if (Game.isNotSetup()) {
            return;
        }
        if (status == Status.STANDBY) {
            Game.whileWaiting();
        } else if (status == Status.STARTING) {
            Game.whileStarting();
        } else if (status == Status.PLAYING) {
            Game.whilePlaying();
        }
        ++tick;
    }

    public static void resetWorldborder(String worldName) {
        worldBorder.resetWorldborder(worldName);
    }

    public static void broadcastMessage(String message) {
        for (Player player : Board.getPlayers()) {
            player.sendMessage(message);
        }
    }

    public static void resetPlayer(Player player) {
        player.getInventory().clear();
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        if (Board.isSeeker(player)) {
            if (Config.pvpEnabled) {
                for (ItemStack item : Items.SEEKER_ITEMS) {
                    player.getInventory().addItem(new ItemStack[]{item});
                }
            }
            for (PotionEffect effect : Items.SEEKER_EFFECTS) {
                player.addPotionEffect(effect);
            }
        } else if (Board.isHider(player)) {
            if (Config.pvpEnabled) {
                for (ItemStack item : Items.HIDER_ITEMS) {
                    player.getInventory().addItem(new ItemStack[]{item});
                }
            }
            for (PotionEffect effect : Items.HIDER_EFFECTS) {
                player.addPotionEffect(effect);
            }
            if (Config.glowEnabled) {
                ItemStack snowball = new ItemStack(Material.SNOWBALL, 1);
                ItemMeta snowballMeta = snowball.getItemMeta();
                assert (snowballMeta != null);
                snowballMeta.setDisplayName("Glow Powerup");
                ArrayList<String> snowballLore = new ArrayList<String>();
                snowballLore.add("Throw to make all seekers glow");
                snowballLore.add("Last 30s, all hiders can see it");
                snowballLore.add("Time stacks on multi use");
                snowballMeta.setLore(snowballLore);
                snowball.setItemMeta(snowballMeta);
                player.getInventory().addItem(new ItemStack[]{snowball});
            }
        }
    }

    public static void join(Player player) {
        if (status == Status.STANDBY) {
            player.getInventory().clear();
            Board.addHider(player);
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.messagePrefix + Localization.message("GAME_JOIN").addPlayer((Entity)player)));
            } else {
                Game.broadcastMessage(Config.messagePrefix + Localization.message("GAME_JOIN").addPlayer((Entity)player));
            }
            player.teleport(new Location(Bukkit.getWorld((String)Config.lobbyWorld), Config.lobbyPosition.getX(), Config.lobbyPosition.getY(), Config.lobbyPosition.getZ()));
            player.setGameMode(GameMode.ADVENTURE);
            Board.createLobbyBoard(player);
            Board.reloadLobbyBoards();
        } else {
            Board.addSpectator(player);
            player.sendMessage(Config.messagePrefix + Localization.message("GAME_JOIN_SPECTATOR"));
            player.setGameMode(GameMode.SPECTATOR);
            Board.createGameBoard(player);
            player.teleport(new Location(Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld)), Config.spawnPosition.getX(), Config.spawnPosition.getY(), Config.spawnPosition.getZ()));
            player.sendTitle(ChatColor.GRAY + "" + ChatColor.BOLD + "SPECTATING", ChatColor.WHITE + Localization.message("SPECTATOR_SUBTITLE").toString(), 10, 70, 20);
        }
        player.setFoodLevel(20);
        player.setHealth(Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getBaseValue());
    }

    public static void removeItems(Player player) {
        for (ItemStack si : Items.SEEKER_ITEMS) {
            for (ItemStack i : player.getInventory().getContents()) {
                if (!si.isSimilar(i)) continue;
                player.getInventory().remove(i);
            }
        }
        for (ItemStack hi : Items.HIDER_ITEMS) {
            for (ItemStack i : player.getInventory().getContents()) {
                if (!hi.isSimilar(i)) continue;
                player.getInventory().remove(i);
            }
        }
    }

    private static void whileWaiting() {
        if (Config.lobbyCountdownEnabled) {
            if (Config.lobbyMin <= Board.size()) {
                if (countdownTime == -1) {
                    countdownTime = Config.countdown;
                }
                if (Board.size() >= Config.changeCountdown) {
                    countdownTime = Math.min(countdownTime, 10);
                }
                if (tick % 20 == 0) {
                    --countdownTime;
                }
                if (countdownTime == 0) {
                    Optional rand = Board.getPlayers().stream().skip(new Random().nextInt(Board.size())).findFirst();
                    if (!rand.isPresent()) {
                        Main.plugin.getLogger().warning("Failed to select random seeker.");
                        return;
                    }
                    String seekerName = ((Player)rand.get()).getName();
                    Player seeker = Board.getPlayer(seekerName);
                    Game.start(seeker);
                }
            } else {
                countdownTime = -1;
            }
        }
    }

    private static void whileStarting() {
        Game.checkWinConditions();
    }

    private static void whilePlaying() {
        for (Player hider : Board.getHiders()) {
            int distance = 100;
            int temp = 100;
            for (Player seeker : Board.getSeekers()) {
                try {
                    temp = (int)hider.getLocation().distance(seeker.getLocation());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (distance <= temp) continue;
                distance = temp;
            }
            switch (tick % 10) {
                case 0: {
                    if (distance < 30) {
                        Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BASEDRUM, 0.5f, 1.0f);
                    }
                    if (distance >= 10) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 3: {
                    if (distance < 30) {
                        Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BASEDRUM, 0.3f, 1.0f);
                    }
                    if (distance >= 10) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 6: {
                    if (distance >= 10) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 9: {
                    if (distance >= 20) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                }
            }
        }
        if (tick % 20 == 0) {
            if (Config.gameLength > 0) {
                Board.reloadGameBoards();
                --timeLeft;
            }
            if (Config.worldborderEnabled) {
                worldBorder.update();
            }
            if (Config.tauntEnabled) {
                taunt.update();
            }
            if (Config.glowEnabled) {
                glow.update();
            }
        }
        Game.checkWinConditions();
    }

    private static void checkWinConditions() {
        if (Board.sizeHider() < 1) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_FOUND")));
            } else {
                Game.broadcastMessage(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_FOUND"));
            }
            Game.stop(WinType.SEEKER_WIN);
        } else if (Board.sizeSeeker() < 1) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.abortPrefix + Localization.message("GAME_GAMEOVER_SEEKERS_QUIT")));
            } else {
                Game.broadcastMessage(Config.abortPrefix + Localization.message("GAME_GAMEOVER_SEEKERS_QUIT"));
            }
            Game.stop(WinType.NONE);
        } else if (timeLeft < 1) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_TIME")));
            } else {
                Game.broadcastMessage(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_TIME"));
            }
            Game.stop(WinType.HIDER_WIN);
        }
    }

    private static void sendDelayedMessage(String message, int gameId, int delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Main.plugin, () -> {
            if (gameId == Game.gameId) {
                Game.broadcastMessage(message);
            }
        }, (long)delay);
    }

    static {
        tick = 0;
        countdownTime = -1;
        gameId = 0;
        timeLeft = 0;
        status = Status.STANDBY;
        worldLoader = new WorldLoader(Config.spawnWorld);
    }
}

