/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.util.Packet;
import net.tylermurphy.hideAndSeek.util.Status;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class EventListener
implements Listener {
    public static final Map<UUID, Location> temp_loc = new HashMap<UUID, Location>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Board.remove(event.getPlayer());
        Game.removeItems(event.getPlayer());
        if (Game.isNotSetup()) {
            return;
        }
        if (Config.autoJoin) {
            Game.join(event.getPlayer());
        } else if (Config.teleportToExit) {
            if (event.getPlayer().getWorld().getName().equals("hideandseek_" + Config.spawnWorld) || event.getPlayer().getWorld().getName().equals(Config.lobbyWorld)) {
                event.getPlayer().teleport(new Location(Bukkit.getWorld((String)Config.exitWorld), Config.exitPosition.getX(), Config.exitPosition.getY(), Config.exitPosition.getZ()));
                event.getPlayer().setGameMode(GameMode.ADVENTURE);
            }
        } else if (event.getPlayer().getWorld().getName().equals("hideandseek_" + Config.spawnWorld)) {
            if (Game.status != Status.STANDBY) {
                Game.join(event.getPlayer());
            } else {
                event.getPlayer().teleport(new Location(Bukkit.getWorld((String)Config.exitWorld), Config.exitPosition.getX(), Config.exitPosition.getY(), Config.exitPosition.getZ()));
                event.getPlayer().setGameMode(GameMode.ADVENTURE);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        Board.remove(event.getPlayer());
        if (Game.status == Status.STANDBY) {
            Board.reloadLobbyBoards();
        } else {
            Board.reloadGameBoards();
        }
        for (PotionEffect effect : event.getPlayer().getActivePotionEffects()) {
            event.getPlayer().removePotionEffect(effect.getType());
        }
        Game.removeItems(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onKick(PlayerKickEvent event) {
        Board.remove(event.getPlayer());
        if (Game.status == Status.STANDBY) {
            Board.reloadLobbyBoards();
        } else {
            Board.reloadGameBoards();
        }
        for (PotionEffect effect : event.getPlayer().getActivePotionEffects()) {
            event.getPlayer().removePotionEffect(effect.getType());
        }
        Game.removeItems(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChat(AsyncPlayerChatEvent event) {
        if (Board.isSeeker(event.getPlayer())) {
            event.setCancelled(true);
            Board.getSpectators().forEach(spectator -> spectator.sendMessage(ChatColor.GRAY + "[SPECTATOR] " + event.getPlayer().getName() + ": " + event.getMessage()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMove(PlayerMoveEvent event) {
        if (!event.getPlayer().getWorld().getName().equals("hideandseek_" + Config.spawnWorld)) {
            return;
        }
        if (event.getPlayer().hasPermission("hideandseek.leavebounds")) {
            return;
        }
        if (event.getTo() == null || event.getTo().getWorld() == null) {
            return;
        }
        if (!event.getTo().getWorld().getName().equals("hideandseek_" + Config.spawnWorld)) {
            return;
        }
        if (event.getTo().getBlockX() < Config.saveMinX || event.getTo().getBlockX() > Config.saveMaxX || event.getTo().getBlockZ() < Config.saveMinZ || event.getTo().getBlockZ() > Config.saveMaxZ) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!Board.isPlayer(player)) {
            return;
        }
        event.setKeepInventory(true);
        event.setDeathMessage("");
        temp_loc.put(player.getUniqueId(), player.getLocation());
        Main.plugin.getLogger().severe("Player " + player.getName() + " died when not supposed to. Attempting to roll back death.");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!Board.isPlayer(player)) {
            return;
        }
        if (temp_loc.containsKey(player.getUniqueId())) {
            player.teleport(temp_loc.get(player.getUniqueId()));
            temp_loc.remove(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        try {
            if (event.getEntity() instanceof Player) {
                Entity damager;
                Player player = (Player)event.getEntity();
                if (!Board.isPlayer(player) && event instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)event).getDamager()) instanceof Player && Board.isPlayer((CommandSender)damager)) {
                    event.setCancelled(true);
                    return;
                }
                if (Game.status != Status.PLAYING) {
                    event.setCancelled(true);
                    return;
                }
                Player attacker = null;
                if (event instanceof EntityDamageByEntityEvent) {
                    ProjectileSource source;
                    Entity damager2 = ((EntityDamageByEntityEvent)event).getDamager();
                    if (damager2 instanceof Player) {
                        attacker = (Player)damager2;
                        if (Board.onSameTeam(player, attacker)) {
                            event.setCancelled(true);
                        }
                        if (Board.isSpectator(player)) {
                            event.setCancelled(true);
                        }
                    } else if (damager2 instanceof Arrow && (source = ((Arrow)damager2).getShooter()) instanceof Player) {
                        attacker = (Player)source;
                        if (Board.onSameTeam(player, attacker)) {
                            event.setCancelled(true);
                        }
                        if (Board.isSpectator(player)) {
                            event.setCancelled(true);
                        }
                    }
                }
                if (player.getHealth() - event.getDamage() < 0.0 || !Config.pvpEnabled) {
                    if (Config.spawnPosition == null) {
                        return;
                    }
                    event.setCancelled(true);
                    AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                    if (attribute != null) {
                        player.setHealth(attribute.getValue());
                    }
                    player.teleport(new Location(Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld)), Config.spawnPosition.getX(), Config.spawnPosition.getY(), Config.spawnPosition.getZ()));
                    Packet.playSound(player, Sound.ENTITY_PLAYER_DEATH, 1.0f, 1.0f);
                    if (Board.isSeeker(player)) {
                        Bukkit.broadcastMessage((String)Localization.message("GAME_PLAYER_DEATH").addPlayer((Entity)player).toString());
                    }
                    if (Board.isHider(player)) {
                        if (attacker == null) {
                            Game.broadcastMessage(Localization.message("GAME_PLAYER_FOUND").addPlayer((Entity)player).toString());
                        } else {
                            Game.broadcastMessage(Localization.message("GAME_PLAYER_FOUND_BY").addPlayer((Entity)player).addPlayer((Entity)attacker).toString());
                        }
                        Board.addSeeker(player);
                    }
                    Game.resetPlayer(player);
                    Board.reloadBoardTeams();
                }
            }
        }
        catch (Exception e) {
            Main.plugin.getLogger().severe("Entity Damage Event Error: " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onProjectile(ProjectileLaunchEvent event) {
        if (Game.status != Status.PLAYING) {
            return;
        }
        if (event.getEntity() instanceof Snowball) {
            Player player;
            if (!Config.glowEnabled) {
                return;
            }
            Snowball snowball = (Snowball)event.getEntity();
            if (snowball.getShooter() instanceof Player && Board.isHider(player = (Player)snowball.getShooter())) {
                Game.glow.onProjectile();
                snowball.remove();
                player.getInventory().remove(Material.SNOWBALL);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            if (!Board.isPlayer((Player)event.getEntity())) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRegainHealth(EntityRegainHealthEvent event) {
        if ((event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED || event.getRegainReason() == EntityRegainHealthEvent.RegainReason.REGEN) && event.getEntity() instanceof Player) {
            if (!Board.isPlayer((Player)event.getEntity())) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        String[] array = message.split(" ");
        if (array[0].equalsIgnoreCase("/kill")) {
            if (Board.isPlayer(player)) {
                Main.plugin.getLogger().info("Blocking " + player.getName() + "from running /kill with anyone associated in the lobby");
                event.setCancelled(true);
            } else if (array.length > 1) {
                for (int i = 1; i < array.length; ++i) {
                    if (!Board.isPlayer(array[i])) continue;
                    Main.plugin.getLogger().info("Blocking " + player.getName() + "from running /kill with anyone associated in the lobby");
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }
}

