/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.Game;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldBorder;

class Border {
    private int delay = 60 * Config.worldborderDelay;
    private boolean running;

    void update() {
        if (this.delay == 30 && !this.running) {
            Game.broadcastMessage(Config.worldborderPrefix + Localization.message("WORLDBORDER_WARN"));
        } else if (this.delay == 0) {
            if (this.running) {
                this.delay = 60 * Config.worldborderDelay;
                this.running = false;
            } else {
                this.decreaceWorldborder();
            }
        }
        --this.delay;
    }

    private void decreaceWorldborder() {
        if (Config.currentWorldborderSize - 100 > 100) {
            this.running = true;
            Game.broadcastMessage(Config.worldborderPrefix + Localization.message("WORLDBORDER_DECREASING"));
            Config.currentWorldborderSize -= 100;
            World world = Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld));
            assert (world != null);
            WorldBorder border = world.getWorldBorder();
            border.setSize(border.getSize() - 100.0, 30L);
            this.delay = 30;
        }
    }

    public void resetWorldborder(String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        assert (world != null);
        WorldBorder border = world.getWorldBorder();
        if (Config.worldborderEnabled) {
            border.setSize((double)Config.worldborderSize);
            border.setCenter(Config.worldborderPosition.getX(), Config.worldborderPosition.getZ());
            Config.currentWorldborderSize = Config.worldborderSize;
        } else {
            border.setSize(3.0E7);
            border.setCenter(0.0, 0.0);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.running;
    }
}

