/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.game.CustomBoard;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.util.Status;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.ScoreboardManager;

public class Board {
    private static final List<String> Hider = new ArrayList<String>();
    private static final List<String> Seeker = new ArrayList<String>();
    private static final List<String> Spectator = new ArrayList<String>();
    private static final Map<String, Player> playerList = new HashMap<String, Player>();
    private static final Map<String, CustomBoard> customBoards = new HashMap<String, CustomBoard>();

    public static boolean isPlayer(Player player) {
        return playerList.containsKey(player.getName());
    }

    public static boolean isPlayer(String name) {
        return playerList.containsKey(name);
    }

    public static boolean isPlayer(CommandSender sender) {
        return playerList.containsKey(sender.getName());
    }

    public static boolean isHider(Player player) {
        return Hider.contains(player.getName());
    }

    public static boolean isSeeker(Player player) {
        return Seeker.contains(player.getName());
    }

    public static boolean isSpectator(Player player) {
        return Spectator.contains(player.getName());
    }

    public static int sizeHider() {
        return Hider.size();
    }

    public static int sizeSeeker() {
        return Seeker.size();
    }

    public static int size() {
        return playerList.values().size();
    }

    public static List<Player> getHiders() {
        return Hider.stream().map(playerList::get).collect(Collectors.toList());
    }

    public static List<Player> getSeekers() {
        return Seeker.stream().map(playerList::get).collect(Collectors.toList());
    }

    public static Player getFirstSeeker() {
        return playerList.get(Seeker.get(0));
    }

    public static List<Player> getSpectators() {
        return Spectator.stream().map(playerList::get).collect(Collectors.toList());
    }

    public static List<Player> getPlayers() {
        return new ArrayList<Player>(playerList.values());
    }

    public static Player getPlayer(String name) {
        return playerList.get(name);
    }

    public static void addHider(Player player) {
        Hider.add(player.getName());
        Seeker.remove(player.getName());
        Spectator.remove(player.getName());
        playerList.put(player.getName(), player);
    }

    public static void addSeeker(Player player) {
        Hider.remove(player.getName());
        Seeker.add(player.getName());
        Spectator.remove(player.getName());
        playerList.put(player.getName(), player);
    }

    public static void addSpectator(Player player) {
        Hider.remove(player.getName());
        Seeker.remove(player.getName());
        Spectator.add(player.getName());
        playerList.put(player.getName(), player);
    }

    public static void remove(Player player) {
        Hider.remove(player.getName());
        Seeker.remove(player.getName());
        Spectator.remove(player.getName());
        playerList.remove(player.getName());
    }

    public static boolean onSameTeam(Player player1, Player player2) {
        if (Hider.contains(player1.getName()) && Hider.contains(player2.getName())) {
            return true;
        }
        if (Seeker.contains(player1.getName()) && Seeker.contains(player2.getName())) {
            return true;
        }
        return Spectator.contains(player1.getName()) && Spectator.contains(player2.getName());
    }

    public static void reload() {
        Hider.clear();
        Seeker.clear();
        Spectator.clear();
    }

    public static void createLobbyBoard(Player player) {
        Board.createLobbyBoard(player, true);
    }

    private static void createLobbyBoard(Player player, boolean recreate) {
        CustomBoard board = customBoards.get(player.getName());
        if (recreate) {
            board = new CustomBoard(player, "&l&eHIDE AND SEEK");
            board.updateTeams();
        }
        board.setLine("hiders", ChatColor.BOLD + "" + ChatColor.YELLOW + "HIDER %" + ChatColor.WHITE + Board.getHiderPercent());
        board.setLine("seekers", ChatColor.BOLD + "" + ChatColor.RED + "SEEKER %" + ChatColor.WHITE + Board.getSeekerPercent());
        board.addBlank();
        board.setLine("players", "Players: " + playerList.values().size());
        board.addBlank();
        if (Config.lobbyCountdownEnabled) {
            if (Game.countdownTime == -1) {
                board.setLine("waiting", "Waiting for players...");
            } else {
                board.setLine("waiting", "Starting in: " + ChatColor.GREEN + Game.countdownTime + "s");
            }
        } else {
            board.setLine("waiting", "Waiting for gamemaster...");
        }
        board.display();
        customBoards.put(player.getName(), board);
    }

    public static void createGameBoard(Player player) {
        Board.createGameBoard(player, true);
    }

    private static void createGameBoard(Player player, boolean recreate) {
        CustomBoard board = customBoards.get(player.getName());
        if (recreate) {
            board = new CustomBoard(player, "&l&eHIDE AND SEEK");
            board.updateTeams();
        }
        board.setLine("hiders", ChatColor.BOLD + "" + ChatColor.YELLOW + "HIDERS:" + ChatColor.WHITE + " " + Hider.size());
        board.setLine("seekers", ChatColor.BOLD + "" + ChatColor.RED + "SEEKERS:" + ChatColor.WHITE + " " + Seeker.size());
        board.addBlank();
        if (Config.glowEnabled) {
            if (Game.glow == null || Game.status == Status.STARTING || !Game.glow.isRunning()) {
                board.setLine("glow", "Glow: " + ChatColor.RED + "Inactive");
            } else {
                board.setLine("glow", "Glow: " + ChatColor.GREEN + "Active");
            }
        }
        if (Config.tauntEnabled && Config.tauntCountdown) {
            if (Game.taunt == null || Game.status == Status.STARTING) {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + "0m0s");
            } else if (!Config.tauntLast && Hider.size() == 1) {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + "Expired");
            } else if (!Game.taunt.isRunning()) {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + Game.taunt.getDelay() / 60 + "m" + Game.taunt.getDelay() % 60 + "s");
            } else {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + "Active");
            }
        }
        if (Config.worldborderEnabled) {
            if (Game.worldBorder == null || Game.status == Status.STARTING) {
                board.setLine("board", "WorldBorder: " + ChatColor.YELLOW + "0m0s");
            } else if (!Game.worldBorder.isRunning()) {
                board.setLine("board", "WorldBorder: " + ChatColor.YELLOW + Game.worldBorder.getDelay() / 60 + "m" + Game.worldBorder.getDelay() % 60 + "s");
            } else {
                board.setLine("board", "WorldBorder: " + ChatColor.YELLOW + "Decreasing");
            }
        }
        if (Config.glowEnabled || Config.tauntEnabled && Config.tauntCountdown || Config.worldborderEnabled) {
            board.addBlank();
        }
        board.setLine("time", "Time Left: " + ChatColor.GREEN + Game.timeLeft / 60 + "m" + Game.timeLeft % 60 + "s");
        board.addBlank();
        board.setLine("team", "Team: " + Board.getTeam(player));
        board.display();
        customBoards.put(player.getName(), board);
    }

    public static void removeBoard(Player player) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        assert (manager != null);
        player.setScoreboard(manager.getMainScoreboard());
        customBoards.remove(player.getName());
    }

    public static void reloadLobbyBoards() {
        for (Player player : playerList.values()) {
            Board.createLobbyBoard(player, false);
        }
    }

    public static void reloadGameBoards() {
        for (Player player : playerList.values()) {
            Board.createGameBoard(player, false);
        }
    }

    public static void reloadBoardTeams() {
        for (CustomBoard board : customBoards.values()) {
            board.updateTeams();
        }
    }

    private static String getSeekerPercent() {
        if (playerList.values().size() < 2) {
            return " --";
        }
        return " " + (int)(100.0 * (1.0 / (double)playerList.size()));
    }

    private static String getHiderPercent() {
        if (playerList.size() < 2) {
            return " --";
        }
        return " " + (int)(100.0 - 100.0 * (1.0 / (double)playerList.size()));
    }

    private static String getTeam(Player player) {
        if (Board.isHider(player)) {
            return ChatColor.GOLD + "HIDER";
        }
        if (Board.isSeeker(player)) {
            return ChatColor.RED + "SEEKER";
        }
        if (Board.isSpectator(player)) {
            return ChatColor.GRAY + "SPECTATOR";
        }
        return ChatColor.WHITE + "UNKNOWN";
    }
}

