/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.database;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.database.Database;
import net.tylermurphy.hideAndSeek.database.PlayerInfo;
import net.tylermurphy.hideAndSeek.util.WinType;

public class PlayerInfoTable {
    protected PlayerInfoTable() {
        String sql = "CREATE TABLE IF NOT EXISTS player_info (\n\tuuid BINARY(16) PRIMARY KEY,\n\twins int NOT NULL,\n\tseeker_wins int NOT NULL,\n\thider_wins int NOT NULL,\n\tgames_played int NOT NULL\n);";
        try (Connection connection = Database.connect();
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            Main.plugin.getLogger().severe("SQL Error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlayerInfo getInfo(UUID uuid) {
        String sql = "SELECT * FROM player_info WHERE uuid = ?;";
        try (Connection connection = Database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            InputStream is = Database.convertUniqueId(uuid);
            byte[] bytes = new byte[is.available()];
            if (is.read(bytes) == -1) {
                throw new IOException("Failed to read bytes from input stream");
            }
            statement.setBytes(1, bytes);
            ResultSet rs = statement.executeQuery();
            if (!rs.next()) return new PlayerInfo(uuid, 0, 0, 0, 0);
            PlayerInfo playerInfo = new PlayerInfo(uuid, rs.getInt("wins"), rs.getInt("seeker_wins"), rs.getInt("hider_wins"), rs.getInt("games_played"));
            return playerInfo;
        }
        catch (SQLException e) {
            Main.plugin.getLogger().severe("SQL Error: " + e.getMessage());
            return new PlayerInfo(uuid, 0, 0, 0, 0);
        }
        catch (IOException e) {
            Main.plugin.getLogger().severe("IO Error: " + e.getMessage());
            e.printStackTrace();
        }
        return new PlayerInfo(uuid, 0, 0, 0, 0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<PlayerInfo> getInfoPage(int page) {
        String sql = "SELECT * FROM player_info ORDER BY wins DESC LIMIT 10 OFFSET ?;";
        try (Connection connection = Database.connect();){
            ArrayList<PlayerInfo> arrayList;
            block15: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, (page - 1) * 10);
                    ResultSet rs = statement.executeQuery();
                    ArrayList<PlayerInfo> infoList = new ArrayList<PlayerInfo>();
                    while (rs.next()) {
                        PlayerInfo info = new PlayerInfo(Database.convertBinaryStream(rs.getBinaryStream("uuid")), rs.getInt("wins"), rs.getInt("seeker_wins"), rs.getInt("hider_wins"), rs.getInt("games_played"));
                        infoList.add(info);
                    }
                    arrayList = infoList;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Main.plugin.getLogger().severe("SQL Error: " + e.getMessage());
            return null;
        }
    }

    public void addWins(List<UUID> uuids, List<UUID> winners, WinType type) {
        for (UUID uuid : uuids) {
            String sql = "INSERT OR REPLACE INTO player_info (uuid, wins, seeker_wins, hider_wins, games_played) VALUES (?,?,?,?,?)";
            PlayerInfo info = this.getInfo(uuid);
            try {
                Connection connection = Database.connect();
                try {
                    PreparedStatement statement = connection.prepareStatement(sql);
                    try {
                        InputStream is = Database.convertUniqueId(uuid);
                        byte[] bytes = new byte[is.available()];
                        if (is.read(bytes) == -1) {
                            throw new IOException("Failed to read bytes from input stream");
                        }
                        statement.setBytes(1, bytes);
                        statement.setInt(2, info.wins + (winners.contains(uuid) ? 1 : 0));
                        statement.setInt(3, info.seeker_wins + (winners.contains(uuid) && type == WinType.SEEKER_WIN ? 1 : 0));
                        statement.setInt(4, info.hider_wins + (winners.contains(uuid) && type == WinType.HIDER_WIN ? 1 : 0));
                        statement.setInt(5, info.games_played + 1);
                        statement.execute();
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                Main.plugin.getLogger().severe("SQL Error: " + e.getMessage());
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                Main.plugin.getLogger().severe("IO Error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

