/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import net.tylermurphy.hideAndSeek.Main;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private final File file;
    private YamlConfiguration config;
    private YamlConfiguration defaultConfig;
    private String defaultFilename;

    public ConfigManager(String filename) {
        this.file = new File(Main.data, filename);
        this.defaultFilename = this.file.getName();
        File folder = Main.data;
        if (!folder.exists() && !folder.mkdirs()) {
            throw new RuntimeException("Failed to make directory: " + this.file.getPath());
        }
        if (!this.file.exists()) {
            this.saveDefaultConfiguration();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        InputStream input = Main.plugin.getResource(this.file.getName());
        if (input == null) {
            throw new RuntimeException("Could not create input stream for " + this.file.getPath());
        }
        InputStreamReader reader = new InputStreamReader(input);
        this.defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
        try {
            input.close();
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ConfigManager(String filename, String defaultFilename) {
        this.defaultFilename = defaultFilename;
        this.file = new File(Main.data, filename);
        if (!this.file.exists()) {
            this.saveDefaultConfiguration();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        InputStream input = Main.plugin.getResource(defaultFilename);
        if (input == null) {
            throw new RuntimeException("Could not create input stream for " + defaultFilename);
        }
        InputStreamReader reader = new InputStreamReader(input);
        this.defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
        try {
            input.close();
            reader.close();
        }
        catch (IOException e) {
            Main.plugin.getLogger().severe("Couldn't find " + defaultFilename + " internally. Did you set an incorrect local?");
            Main.plugin.getServer().getPluginManager().disablePlugin((Plugin)Main.plugin);
            throw new RuntimeException();
        }
    }

    private void saveDefaultConfiguration() {
        try {
            InputStream input = Main.plugin.getResource(this.defaultFilename);
            if (input == null) {
                throw new RuntimeException("Could not create input stream for " + this.defaultFilename);
            }
            Files.copy(input, this.file.toPath(), new CopyOption[0]);
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getDouble(String path) {
        double value = this.config.getDouble(path);
        if (value == 0.0) {
            return this.defaultConfig.getDouble(path);
        }
        return value;
    }

    public int getInt(String path) {
        int value = this.config.getInt(path);
        if (value == 0) {
            return this.defaultConfig.getInt(path);
        }
        return value;
    }

    public String getString(String path) {
        String value = this.config.getString(path);
        if (value == null) {
            return this.defaultConfig.getString(path);
        }
        return value;
    }

    public void reset(String path) {
        this.config.set(path, this.defaultConfig.get(path));
    }

    public void resetFile(String newDefaultFilename) {
        this.defaultFilename = newDefaultFilename;
        InputStream input = Main.plugin.getResource(this.defaultFilename);
        if (input == null) {
            throw new RuntimeException("Could not create input stream for " + this.defaultFilename);
        }
        InputStreamReader reader = new InputStreamReader(input);
        this.config = YamlConfiguration.loadConfiguration((Reader)reader);
        this.defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
    }

    public boolean getBoolean(String path) {
        boolean value = this.config.getBoolean(path);
        if (!value) {
            return this.defaultConfig.getBoolean(path);
        }
        return true;
    }

    public ConfigurationSection getConfigurationSection(String path) {
        ConfigurationSection section = this.config.getConfigurationSection(path);
        if (section == null) {
            return this.defaultConfig.getConfigurationSection(path);
        }
        return section;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public void saveConfig() {
        try {
            int c;
            InputStream is = Main.plugin.getResource(this.defaultFilename);
            if (is == null) {
                throw new RuntimeException("Could not create input stream for " + this.defaultFilename);
            }
            StringBuilder textBuilder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(StandardCharsets.UTF_8.name())));
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
            String yamlString = textBuilder.toString();
            Map temp = this.config.getValues(true);
            for (Map.Entry entry : temp.entrySet()) {
                if (!(entry.getValue() instanceof Integer) && !(entry.getValue() instanceof Double) && !(entry.getValue() instanceof String) && !(entry.getValue() instanceof Boolean)) continue;
                String[] parts = ((String)entry.getKey()).split("\\.");
                int index = 0;
                int i = 0;
                for (String part : parts) {
                    if (i == 0) {
                        index = yamlString.indexOf(part + ":", index);
                    } else {
                        index = yamlString.indexOf(" " + part + ":", index);
                        ++index;
                    }
                    ++i;
                    if (index == -1) break;
                }
                if (index < 10) continue;
                int start = yamlString.indexOf(32, index);
                int end = yamlString.indexOf(10, index);
                if (end == -1) {
                    end = yamlString.length();
                }
                String replace = entry.getValue().toString();
                if (entry.getValue() instanceof String) {
                    replace = "\"" + replace + "\"";
                }
                StringBuilder builder = new StringBuilder(yamlString);
                builder.replace(start + 1, end, replace);
                yamlString = builder.toString();
            }
            PrintWriter out = new PrintWriter(this.file);
            out.print(yamlString);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

