/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.UUID;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.database.Database;
import net.tylermurphy.hideAndSeek.database.PlayerInfo;
import net.tylermurphy.hideAndSeek.util.UUIDFetcher;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Wins
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        Main.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)Main.plugin, () -> {
            String name;
            UUID uuid;
            if (args.length == 0) {
                Player player = Main.plugin.getServer().getPlayer(sender.getName());
                if (player == null) {
                    sender.sendMessage(Config.errorPrefix + Localization.message("START_INVALID_NAME").addPlayer(sender.getName()));
                    return;
                }
                uuid = player.getUniqueId();
                name = sender.getName();
            } else {
                try {
                    name = args[0];
                    uuid = UUIDFetcher.getUUID(args[0]);
                }
                catch (Exception e) {
                    sender.sendMessage(Config.errorPrefix + Localization.message("START_INVALID_NAME").addPlayer(args[0]));
                    return;
                }
            }
            PlayerInfo info = Database.playerInfo.getInfo(uuid);
            if (info == null) {
                sender.sendMessage(Config.errorPrefix + Localization.message("NO_GAME_INFO"));
                return;
            }
            String message = ChatColor.WHITE + "" + ChatColor.BOLD + "==============================\n";
            message = message + Localization.message("INFORMATION_FOR").addPlayer(name) + "\n";
            message = message + "==============================\n";
            message = message + String.format("%sTOTAL WINS: %s%s\n%sHIDER WINS: %s%s\n%sSEEKER WINS: %s%s\n%sGAMES PLAYED: %s", ChatColor.YELLOW, ChatColor.WHITE, info.wins, ChatColor.GOLD, ChatColor.WHITE, info.hider_wins, ChatColor.RED, ChatColor.WHITE, info.seeker_wins, ChatColor.WHITE, info.games_played);
            message = message + ChatColor.WHITE + "" + ChatColor.BOLD + "\n==============================";
            sender.sendMessage(message);
        });
    }

    @Override
    public String getLabel() {
        return "wins";
    }

    @Override
    public String getUsage() {
        return "<player>";
    }

    @Override
    public String getDescription() {
        return "Get the win information for yourself or another player.";
    }
}

