/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.Optional;
import java.util.Random;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.util.Status;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Start
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        String seekerName;
        if (Game.isNotSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        if (Game.status != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        if (!Board.isPlayer(sender)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_NOT_INGAME"));
            return;
        }
        if (Board.size() < Config.minPlayers) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_MIN_PLAYERS").addAmount(Config.minPlayers));
            return;
        }
        if (args.length < 1) {
            Optional rand = Board.getPlayers().stream().skip(new Random().nextInt(Board.size())).findFirst();
            if (!rand.isPresent()) {
                Main.plugin.getLogger().warning("Failed to select random seeker.");
                return;
            }
            seekerName = ((Player)rand.get()).getName();
        } else {
            seekerName = args[0];
        }
        Player seeker = Board.getPlayer(seekerName);
        if (seeker == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_INVALID_NAME").addPlayer(seekerName));
            return;
        }
        Game.start(seeker);
    }

    @Override
    public String getLabel() {
        return "start";
    }

    @Override
    public String getUsage() {
        return "<player>";
    }

    @Override
    public String getDescription() {
        return "Starts the game either with a random seeker or chosen one";
    }
}

