/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.util.Status;
import net.tylermurphy.hideAndSeek.world.WorldLoader;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SetSpawnLocation
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (Game.status != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        Vector newSpawnPosition = new Vector();
        Player player = (Player)sender;
        if (player.getLocation().getBlockX() == 0 || player.getLocation().getBlockZ() == 0 || player.getLocation().getBlockY() == 0) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NOT_AT_ZERO"));
            return;
        }
        newSpawnPosition.setX(player.getLocation().getBlockX());
        newSpawnPosition.setY(player.getLocation().getBlockY());
        newSpawnPosition.setZ(player.getLocation().getBlockZ());
        if (Config.worldborderEnabled && newSpawnPosition.distance(Config.worldborderPosition) > 100.0) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_POSITION"));
            return;
        }
        World world = player.getLocation().getWorld();
        if (world == null) {
            throw new RuntimeException("Unable to get world: " + Config.spawnWorld);
        }
        if (!world.getName().equals(Config.spawnWorld)) {
            Game.worldLoader.unloadMap();
            Game.worldLoader = new WorldLoader(world.getName());
        }
        Config.spawnWorld = world.getName();
        Config.spawnPosition = newSpawnPosition;
        sender.sendMessage(Config.messagePrefix + Localization.message("GAME_SPAWN"));
        Config.addToConfig("spawns.game.x", Config.spawnPosition.getX());
        Config.addToConfig("spawns.game.y", Config.spawnPosition.getY());
        Config.addToConfig("spawns.game.z", Config.spawnPosition.getZ());
        Config.addToConfig("spawns.game.world", player.getLocation().getWorld().getName());
        Config.saveConfig();
    }

    @Override
    public String getLabel() {
        return "setspawn";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Sets hide and seeks spawn location to current position";
    }
}

