/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.util.Status;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Leave
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (Game.isNotSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        Player player = Bukkit.getServer().getPlayer(sender.getName());
        if (player == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_ERROR"));
            return;
        }
        if (!Board.isPlayer(player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_NOT_INGAME"));
            return;
        }
        if (Config.announceMessagesToNonPlayers) {
            Bukkit.broadcastMessage((String)(Config.messagePrefix + Localization.message("GAME_LEAVE").addPlayer((Entity)player)));
        } else {
            Game.broadcastMessage(Config.messagePrefix + Localization.message("GAME_LEAVE").addPlayer((Entity)player));
        }
        Board.removeBoard(player);
        Board.remove(player);
        player.teleport(new Location(Bukkit.getWorld((String)Config.exitWorld), Config.exitPosition.getX(), Config.exitPosition.getY(), Config.exitPosition.getZ()));
        if (Game.status == Status.STANDBY) {
            Board.reloadLobbyBoards();
        } else {
            Board.reloadGameBoards();
            Board.reloadBoardTeams();
        }
    }

    @Override
    public String getLabel() {
        return "leave";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Leaves the lobby if game is set to manual join/leave";
    }
}

