/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek;

import java.io.File;
import java.util.List;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Items;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.database.Database;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.CommandHandler;
import net.tylermurphy.hideAndSeek.game.EventListener;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.util.TabCompleter;
import net.tylermurphy.hideAndSeek.util.UUIDFetcher;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class Main
extends JavaPlugin
implements Listener {
    public static Main plugin;
    public static File root;
    public static File data;
    private BukkitTask onTickTask;

    public void onEnable() {
        plugin = this;
        root = this.getServer().getWorldContainer();
        data = this.getDataFolder();
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)this);
        Config.loadConfig();
        Localization.loadLocalization();
        Items.loadItems();
        CommandHandler.registerCommands();
        Board.reload();
        Database.init();
        UUIDFetcher.init();
        this.onTickTask = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            try {
                Game.onTick();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 0L, 1L);
    }

    public void onDisable() {
        if (this.onTickTask != null) {
            this.onTickTask.cancel();
        }
        UUIDFetcher.cleanup();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        return CommandHandler.handleCommand(sender, args);
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        return TabCompleter.handleTabComplete(sender, args);
    }
}

