/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.util;

import java.util.HashMap;
import java.util.Map;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.util.Line;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class CustomBoard {
    private final Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
    private final Objective obj;
    private final Player player;
    private final Map<String, Line> LINES = new HashMap<String, Line>();
    private int blanks;
    private boolean displayed;

    public CustomBoard(Player player, String title) {
        this.player = player;
        this.obj = this.board.registerNewObjective("Scoreboard", "dummy", ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        this.blanks = 0;
        this.displayed = false;
        this.updateTeams();
    }

    public void updateTeams() {
        try {
            this.board.registerNewTeam("Hider");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.board.registerNewTeam("Seeker");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Team hiderTeam = this.board.getTeam("Hider");
        for (String entry : hiderTeam.getEntries()) {
            hiderTeam.removeEntry(entry);
        }
        for (Player player : Main.plugin.board.getHiders()) {
            hiderTeam.addEntry(player.getName());
        }
        Team seekerTeam = this.board.getTeam("Seeker");
        for (String entry : seekerTeam.getEntries()) {
            seekerTeam.removeEntry(entry);
        }
        for (Player player : Main.plugin.board.getSeekers()) {
            seekerTeam.addEntry(player.getName());
        }
        if (Config.nametagsVisible) {
            hiderTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OWN_TEAM);
            seekerTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
        } else {
            hiderTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            seekerTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        }
        hiderTeam.setColor(ChatColor.GOLD);
        seekerTeam.setColor(ChatColor.RED);
    }

    public void setLine(String key, String message) {
        Line line = this.LINES.get(key);
        if (line == null) {
            this.addLine(key, message);
        } else {
            this.updateLine(key, message);
        }
    }

    private void addLine(String key, String message) {
        Score score = this.obj.getScore(message);
        score.setScore(this.LINES.values().size() + 1);
        Line line = new Line(this.LINES.values().size() + 1, message);
        this.LINES.put(key, line);
    }

    public void addBlank() {
        if (this.displayed) {
            return;
        }
        String temp = "";
        for (int i = 0; i <= this.blanks; ++i) {
            temp = temp + ChatColor.RESET;
        }
        ++this.blanks;
        this.addLine("blank" + this.blanks, temp);
    }

    private void updateLine(String key, String message) {
        Line line = this.LINES.get(key);
        this.board.resetScores(line.getMessage());
        line.setMessage(message);
        Score newScore = this.obj.getScore(message);
        newScore.setScore(line.getScore());
    }

    public void display() {
        this.displayed = true;
        this.obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.player.setScoreboard(this.board);
    }
}

