/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.util.CustomBoard;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Board {
    private List<String> Hider;
    private List<String> Seeker;
    private List<String> Spectator;
    private Map<String, Player> playerList = new HashMap<String, Player>();
    private Map<String, CustomBoard> customBoards = new HashMap<String, CustomBoard>();

    public boolean isPlayer(Player player) {
        return this.playerList.containsKey(player.getName());
    }

    public boolean isPlayer(CommandSender sender) {
        return this.playerList.containsKey(sender.getName());
    }

    public boolean isHider(Player player) {
        return this.Hider.contains(player.getName());
    }

    public boolean isSeeker(Player player) {
        return this.Seeker.contains(player.getName());
    }

    public boolean isSpectator(Player player) {
        return this.Spectator.contains(player.getName());
    }

    public int sizeHider() {
        return this.Hider.size();
    }

    public int sizeSeeker() {
        return this.Seeker.size();
    }

    public int sizeSpectator() {
        return this.Spectator.size();
    }

    public int size() {
        return this.playerList.values().size();
    }

    public List<Player> getHiders() {
        return this.Hider.stream().map(playerName -> this.playerList.get(playerName)).collect(Collectors.toList());
    }

    public List<Player> getSeekers() {
        return this.Seeker.stream().map(playerName -> this.playerList.get(playerName)).collect(Collectors.toList());
    }

    public List<Player> getSpectators() {
        return this.Spectator.stream().map(playerName -> this.playerList.get(playerName)).collect(Collectors.toList());
    }

    public List<Player> getPlayers() {
        return new ArrayList<Player>(this.playerList.values());
    }

    public Player getPlayer(String name) {
        return this.playerList.get(name);
    }

    public void addHider(Player player) {
        this.Hider.add(player.getName());
        this.Seeker.remove(player.getName());
        this.Spectator.remove(player.getName());
        this.playerList.put(player.getName(), player);
    }

    public void addSeeker(Player player) {
        this.Hider.remove(player.getName());
        this.Seeker.add(player.getName());
        this.Spectator.remove(player.getName());
        this.playerList.put(player.getName(), player);
    }

    public void addSpectator(Player player) {
        this.Hider.remove(player.getName());
        this.Seeker.remove(player.getName());
        this.Spectator.add(player.getName());
        this.playerList.put(player.getName(), player);
    }

    public void remove(Player player) {
        this.Hider.remove(player.getName());
        this.Seeker.remove(player.getName());
        this.Spectator.remove(player.getName());
        this.playerList.remove(player.getName());
    }

    public boolean onSameTeam(Player player1, Player player2) {
        if (this.Hider.contains(player1.getName()) && this.Hider.contains(player2.getName())) {
            return true;
        }
        if (this.Seeker.contains(player1.getName()) && this.Seeker.contains(player2.getName())) {
            return true;
        }
        return this.Spectator.contains(player1.getName()) && this.Spectator.contains(player2.getName());
    }

    public void reload() {
        this.Hider = new ArrayList<String>();
        this.Seeker = new ArrayList<String>();
        this.Spectator = new ArrayList<String>();
    }

    public void reset() {
        this.Hider.clear();
        this.Seeker.clear();
        this.Spectator.clear();
    }

    private void createTeamsForBoard(Scoreboard board) {
        Team hiderTeam = board.registerNewTeam("Hider");
        for (String name : this.Hider) {
            hiderTeam.addEntry(name);
        }
        Team seekerTeam = board.registerNewTeam("Seeker");
        for (String name : this.Seeker) {
            seekerTeam.addEntry(name);
        }
        if (Config.nametagsVisible) {
            hiderTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OWN_TEAM);
            seekerTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
        } else {
            hiderTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            seekerTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        }
    }

    public void createLobbyBoard(Player player) {
        this.createLobbyBoard(player, true);
    }

    private void createLobbyBoard(Player player, boolean recreate) {
        CustomBoard board = this.customBoards.get(player.getName());
        if (recreate) {
            board = new CustomBoard(player, "&l&eHIDE AND SEEK");
            board.updateTeams();
        }
        board.setLine("hiders", ChatColor.BOLD + "" + ChatColor.YELLOW + "HIDER%" + ChatColor.WHITE + this.getHiderPercent());
        board.setLine("seekers", ChatColor.BOLD + "" + ChatColor.RED + "SEEKER%" + ChatColor.WHITE + this.getSeekerPercent());
        board.addBlank();
        board.setLine("players", "Players: " + this.playerList.values().size());
        board.addBlank();
        board.setLine("waiting", "Waiting to start...");
        board.display();
        this.customBoards.put(player.getName(), board);
    }

    public void createGameBoard(Player player) {
        this.createGameBoard(player, true);
    }

    private void createGameBoard(Player player, boolean recreate) {
        CustomBoard board = this.customBoards.get(player.getName());
        if (recreate) {
            board = new CustomBoard(player, "&l&eHIDE AND SEEK");
        }
        board.setLine("hiders", ChatColor.BOLD + "" + ChatColor.YELLOW + "HIDERS:" + ChatColor.WHITE + " " + this.Hider.size());
        board.setLine("seekers", ChatColor.BOLD + "" + ChatColor.RED + "SEEKERS:" + ChatColor.WHITE + " " + this.Seeker.size());
        board.addBlank();
        if (Config.glowEnabled) {
            if (Main.plugin.glow == null || Main.plugin.status.equals("Starting") || !Main.plugin.glow.isRunning()) {
                board.setLine("glow", "Glow: " + ChatColor.RED + "Inactive");
            } else {
                board.setLine("glow", "Glow: " + ChatColor.GREEN + "Active");
            }
        }
        if (Config.tauntEnabled && Config.tauntCountdown) {
            if (Main.plugin.taunt == null || Main.plugin.status.equals("Starting")) {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + "0m0s");
            } else if (!Config.tauntLast && this.Hider.size() == 1) {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + "Expired");
            } else if (!Main.plugin.taunt.isRunning()) {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + Main.plugin.taunt.getDelay() / 60 + "m" + Main.plugin.taunt.getDelay() % 60 + "s");
            } else {
                board.setLine("taunt", "Taunt: " + ChatColor.YELLOW + "Active");
            }
        }
        if (Config.worldborderEnabled) {
            if (Main.plugin.worldborder == null || Main.plugin.status.equals("Starting")) {
                board.setLine("board", "WorldBorder: " + ChatColor.YELLOW + "0m0s");
            } else if (!Main.plugin.worldborder.isRunning()) {
                board.setLine("board", "WorldBorder: " + ChatColor.YELLOW + Main.plugin.worldborder.getDelay() / 60 + "m" + Main.plugin.worldborder.getDelay() % 60 + "s");
            } else {
                board.setLine("board", "WorldBorder: " + ChatColor.YELLOW + "Decreasing");
            }
        }
        if (Config.glowEnabled || Config.tauntEnabled && Config.tauntCountdown || Config.worldborderEnabled) {
            board.addBlank();
        }
        board.setLine("time", "Time Left: " + ChatColor.GREEN + Main.plugin.timeLeft / 60 + "m" + Main.plugin.timeLeft % 60 + "s");
        board.addBlank();
        board.setLine("team", "Team: " + this.getTeam(player));
        board.display();
        this.customBoards.put(player.getName(), board);
    }

    public void removeBoard(Player player) {
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        this.customBoards.remove(player.getName());
    }

    public void reloadLobbyBoards() {
        for (Player player : this.playerList.values()) {
            this.createLobbyBoard(player, false);
        }
    }

    public void reloadGameBoards() {
        for (Player player : this.playerList.values()) {
            this.createGameBoard(player, false);
        }
    }

    public void reloadBoardTeams() {
        for (CustomBoard board : this.customBoards.values()) {
            board.updateTeams();
        }
    }

    private String getSeekerPercent() {
        if (this.playerList.values().size() < 2) {
            return " --";
        }
        return " " + (int)(100.0 * (1.0 / (double)this.playerList.size()));
    }

    private String getHiderPercent() {
        if (this.playerList.size() < 2) {
            return " --";
        }
        return " " + (int)(100.0 - 100.0 * (1.0 / (double)this.playerList.size()));
    }

    private String getTeam(Player player) {
        if (this.isHider(player)) {
            return ChatColor.GOLD + "HIDER";
        }
        if (this.isSeeker(player)) {
            return ChatColor.RED + "SEEKER";
        }
        if (this.isSpectator(player)) {
            return ChatColor.GRAY + "SPECTATOR";
        }
        return ChatColor.WHITE + "UNKNOWN";
    }
}

