/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.events;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class Taunt {
    private final int temp;
    private String tauntPlayer;
    private int delay;
    private boolean running;

    public Taunt(int temp) {
        this.temp = temp;
        this.delay = 0;
    }

    public void schedule() {
        this.delay = Config.tauntDelay;
        this.waitTaunt();
    }

    private void waitTaunt() {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, () -> {
            if (this.delay == 0) {
                if (!Config.tauntLast && Main.plugin.board.size() < 2) {
                    return;
                }
                this.executeTaunt();
            } else {
                --this.delay;
                this.waitTaunt();
            }
        }, 20L);
    }

    private void executeTaunt() {
        if (this.temp != Main.plugin.gameId) {
            return;
        }
        Player taunted = null;
        int rand = (int)(Math.random() * (double)Main.plugin.board.sizeHider());
        for (Player player : Main.plugin.board.getPlayers()) {
            if (!Main.plugin.board.isHider(player) || --rand != 0) continue;
            taunted = player;
            break;
        }
        if (taunted != null) {
            this.running = true;
            taunted.sendMessage(Localization.message("TAUNTED").toString());
            Util.broadcastMessage(Config.tauntPrefix + Localization.message("TAUNT"));
            this.tauntPlayer = taunted.getName();
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, () -> {
                if (this.temp != Main.plugin.gameId) {
                    return;
                }
                Player taunted1 = Main.plugin.board.getPlayer(this.tauntPlayer);
                if (taunted1 != null) {
                    Firework fw = (Firework)taunted1.getLocation().getWorld().spawnEntity(taunted1.getLocation(), EntityType.FIREWORK);
                    FireworkMeta fwm = fw.getFireworkMeta();
                    fwm.setPower(4);
                    fwm.addEffect(FireworkEffect.builder().withColor(Color.BLUE).withColor(Color.RED).withColor(Color.YELLOW).with(FireworkEffect.Type.STAR).with(FireworkEffect.Type.BALL).with(FireworkEffect.Type.BALL_LARGE).flicker(true).withTrail().build());
                    fw.setFireworkMeta(fwm);
                    Util.broadcastMessage(Config.tauntPrefix + Localization.message("TAUNT_ACTIVATE"));
                }
                this.tauntPlayer = "";
                this.running = false;
                this.schedule();
            }, 600L);
        } else {
            this.schedule();
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.running;
    }
}

