/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetBounds
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Main.plugin.status.equals("Standby")) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        if (Config.spawnPosition == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("ERROR_GAME_SPAWN"));
            return;
        }
        Player player = (Player)sender;
        if (!player.getWorld().getName().equals(Config.spawnWorld)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("BOUNDS_WRONG_WORLD"));
            return;
        }
        if (player.getLocation().getBlockX() == 0 || player.getLocation().getBlockZ() == 0) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NOT_AT_ZERO"));
            return;
        }
        boolean first = true;
        if (Config.saveMinX != 0 && Config.saveMinZ != 0 && Config.saveMaxX != 0 && Config.saveMaxZ != 0) {
            Config.saveMinX = 0;
            Config.saveMinZ = 0;
            Config.saveMaxX = 0;
            Config.saveMaxZ = 0;
        }
        if (Config.saveMaxX == 0) {
            Config.addToConfig("bounds.max.x", player.getLocation().getBlockX());
            Config.saveMaxX = player.getLocation().getBlockX();
        } else if (Config.saveMaxX < player.getLocation().getBlockX()) {
            first = false;
            Config.addToConfig("bounds.max.x", player.getLocation().getBlockX());
            Config.addToConfig("bounds.min.x", Config.saveMaxX);
            Config.saveMinX = Config.saveMaxX;
            Config.saveMaxX = player.getLocation().getBlockX();
        } else {
            first = false;
            Config.addToConfig("bounds.min.x", player.getLocation().getBlockX());
            Config.saveMinX = player.getLocation().getBlockX();
        }
        if (Config.saveMaxZ == 0) {
            Config.addToConfig("bounds.max.z", player.getLocation().getBlockZ());
            Config.saveMaxZ = player.getLocation().getBlockZ();
        } else if (Config.saveMaxZ < player.getLocation().getBlockZ()) {
            first = false;
            Config.addToConfig("bounds.max.z", player.getLocation().getBlockZ());
            Config.addToConfig("bounds.min.z", Config.saveMaxZ);
            Config.saveMinZ = Config.saveMaxZ;
            Config.saveMaxZ = player.getLocation().getBlockZ();
        } else {
            first = false;
            Config.addToConfig("bounds.min.z", player.getLocation().getBlockZ());
            Config.saveMinZ = player.getLocation().getBlockZ();
        }
        sender.sendMessage(Config.messagePrefix + Localization.message("BOUNDS").addAmount(first ? 1 : 2));
        Config.saveConfig();
    }

    @Override
    public String getLabel() {
        return "setBounds";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Sets the map bounds for the game.";
    }
}

