/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.events.Worldborder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SetBorder
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        int delay;
        int num;
        if (!Main.plugin.status.equals("Standby")) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        if (Config.spawnPosition == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("ERROR_GAME_SPAWN"));
            return;
        }
        if (args.length < 2) {
            Config.worldborderEnabled = false;
            Config.addToConfig("worldBorder.enabled", false);
            Config.saveConfig();
            sender.sendMessage(Config.messagePrefix + Localization.message("WORLDBORDER_DISABLE"));
            Worldborder.resetWorldborder(Config.spawnWorld);
            return;
        }
        try {
            num = Integer.parseInt(args[0]);
        }
        catch (Exception e) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_INVALID_INPUT").addAmount(args[0]));
            return;
        }
        try {
            delay = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_INVALID_INPUT").addAmount(args[1]));
            return;
        }
        if (num < 100) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_MIN_SIZE"));
            return;
        }
        Vector newWorldborderPosition = new Vector();
        Player player = (Player)sender;
        newWorldborderPosition.setX(player.getLocation().getBlockX());
        newWorldborderPosition.setY(0);
        newWorldborderPosition.setZ(player.getLocation().getBlockZ());
        if (Config.spawnPosition.distance(newWorldborderPosition) > 100.0) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_POSITION"));
            return;
        }
        Config.worldborderPosition = newWorldborderPosition;
        Config.worldborderSize = num;
        Config.worldborderDelay = delay;
        Config.worldborderEnabled = true;
        Config.addToConfig("worldBorder.x", Config.worldborderPosition.getBlockX());
        Config.addToConfig("worldBorder.z", Config.worldborderPosition.getBlockZ());
        Config.addToConfig("worldBorder.delay", Config.worldborderDelay);
        Config.addToConfig("worldBorder.size", Config.worldborderSize);
        Config.addToConfig("worldBorder.enabled", true);
        sender.sendMessage(Config.messagePrefix + Localization.message("WORLDBORDER_ENABLE").addAmount(num).addAmount(delay));
        Config.saveConfig();
        Worldborder.resetWorldborder(Config.spawnWorld);
    }

    @Override
    public String getLabel() {
        return "setBorder";
    }

    @Override
    public String getUsage() {
        return "<size> <delay>";
    }

    @Override
    public String getDescription() {
        return "Sets worldboarder's center location, size in blocks, and delay in minutes per shrink. Add no arguments to disable.";
    }
}

