/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.bukkit;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.Stop;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Packet;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class Tick {
    static int tick = 0;

    public static void onTick() {
        if (Main.plugin.status.equals("Standby")) {
            tick = 0;
        } else if (Main.plugin.status.equals("Playing")) {
            Tick.onPlaying();
        }
        if ((Main.plugin.status.equals("Starting") || Main.plugin.status.equals("Playing")) && Main.plugin.board.sizeHider() < 1) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_FOUND")));
            } else {
                Util.broadcastMessage(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_HIDERS_FOUND"));
            }
            Stop.onStop();
        }
        if ((Main.plugin.status.equals("Starting") || Main.plugin.status.equals("Playing")) && Main.plugin.board.sizeSeeker() < 1) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.abortPrefix + Localization.message("GAME_GAMEOVER_SEEKERS_QUIT")));
            } else {
                Util.broadcastMessage(Config.abortPrefix + Localization.message("GAME_GAMEOVER_SEEKERS_QUIT"));
            }
            Stop.onStop();
        }
    }

    private static void onPlaying() {
        tick = tick < 1000000 ? ++tick : 1;
        for (Player hider : Main.plugin.board.getHiders()) {
            int distance = 100;
            int temp = 100;
            for (Player seeker : Main.plugin.board.getSeekers()) {
                try {
                    temp = (int)hider.getLocation().distance(seeker.getLocation());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (distance <= temp) continue;
                distance = temp;
            }
            switch (tick % 10) {
                case 0: {
                    if (distance < 30) {
                        Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BASEDRUM, 0.5f, 1.0f);
                    }
                    if (distance >= 10) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 3: {
                    if (distance < 30) {
                        Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BASEDRUM, 0.3f, 1.0f);
                    }
                    if (distance >= 10) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 6: {
                    if (distance >= 10) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 9: {
                    if (distance >= 20) break;
                    Packet.playSound(hider, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                }
            }
        }
        if (tick % 20 == 0 && Config.gameLength > 0) {
            Main.plugin.board.reloadGameBoards();
            --Main.plugin.timeLeft;
            if (Main.plugin.timeLeft < 1) {
                if (Config.announceMessagesToNonPlayers) {
                    Bukkit.broadcastMessage((String)(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_TIME")));
                } else {
                    Util.broadcastMessage(Config.gameoverPrefix + Localization.message("GAME_GAMEOVER_TIME"));
                }
                Stop.onStop();
            }
        }
    }
}

