/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.bukkit;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.Join;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Packet;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;

public class EventListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        event.getPlayer().setLevel(0);
        Main.plugin.board.remove(event.getPlayer());
        if (!Util.isSetup()) {
            return;
        }
        if (Config.autoJoin) {
            Join.join(event.getPlayer());
        } else if (Config.teleportToExit) {
            if (event.getPlayer().getWorld().getName().equals("hideandseek_" + Config.spawnWorld) || event.getPlayer().getWorld().getName().equals(Config.lobbyWorld)) {
                event.getPlayer().teleport(new Location(Bukkit.getWorld((String)Config.exitWorld), Config.exitPosition.getX(), Config.exitPosition.getY(), Config.exitPosition.getZ()));
                event.getPlayer().setGameMode(GameMode.ADVENTURE);
            }
        } else if (event.getPlayer().getWorld().getName().equals("hideandseek_" + Config.spawnWorld)) {
            event.getPlayer().teleport(new Location(Bukkit.getWorld((String)Config.exitWorld), Config.exitPosition.getX(), Config.exitPosition.getY(), Config.exitPosition.getZ()));
            event.getPlayer().setGameMode(GameMode.ADVENTURE);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Main.plugin.board.remove(event.getPlayer());
        if (Main.plugin.status.equals("Standby")) {
            Main.plugin.board.reloadLobbyBoards();
        } else {
            Main.plugin.board.reloadGameBoards();
        }
        for (PotionEffect effect : event.getPlayer().getActivePotionEffects()) {
            event.getPlayer().removePotionEffect(effect.getType());
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        Main.plugin.board.remove(event.getPlayer());
        if (Main.plugin.status.equals("Standby")) {
            Main.plugin.board.reloadLobbyBoards();
        } else {
            Main.plugin.board.reloadGameBoards();
        }
        for (PotionEffect effect : event.getPlayer().getActivePotionEffects()) {
            event.getPlayer().removePotionEffect(effect.getType());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        try {
            if (event.getEntity() instanceof Player) {
                Player player;
                Entity damager;
                Player p = (Player)event.getEntity();
                if (!Main.plugin.board.isPlayer(p)) {
                    return;
                }
                if (!Main.plugin.status.equals("Playing")) {
                    event.setCancelled(true);
                    return;
                }
                Player attacker = null;
                if (event instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)event).getDamager()) instanceof Player) {
                    attacker = (Player)damager;
                    if (Main.plugin.board.onSameTeam(p, attacker)) {
                        event.setCancelled(true);
                    }
                    if (Main.plugin.board.isSpectator(p)) {
                        event.setCancelled(true);
                    }
                }
                if ((player = (Player)event.getEntity()).getHealth() - event.getDamage() < 0.0 || !Config.pvpEnabled) {
                    if (Config.spawnPosition == null) {
                        return;
                    }
                    event.setCancelled(true);
                    player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
                    player.teleport(new Location(Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld)), Config.spawnPosition.getX(), Config.spawnPosition.getY(), Config.spawnPosition.getZ()));
                    Packet.playSound(player, Sound.ENTITY_PLAYER_DEATH, 1.0f, 1.0f);
                    if (Main.plugin.board.isSeeker(player)) {
                        Bukkit.broadcastMessage((String)Localization.message("GAME_PLAYER_DEATH").addPlayer(event.getEntity()).toString());
                    }
                    if (Main.plugin.board.isHider(player)) {
                        if (attacker == null) {
                            Util.broadcastMessage(Localization.message("GAME_PLAYER_FOUND").addPlayer(event.getEntity()).toString());
                        } else {
                            Util.broadcastMessage(Localization.message("GAME_PLAYER_FOUND_BY").addPlayer(event.getEntity()).addPlayer((Entity)attacker).toString());
                        }
                        Main.plugin.board.addSeeker(player);
                    }
                    Util.resetPlayer(player);
                    Main.plugin.board.reloadBoardTeams();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onProjectile(ProjectileLaunchEvent event) {
        if (!Main.plugin.status.equals("Playing")) {
            return;
        }
        if (event.getEntity() instanceof Snowball) {
            Player player;
            if (!Config.glowEnabled) {
                return;
            }
            Snowball snowball = (Snowball)event.getEntity();
            if (snowball.getShooter() instanceof Player && Main.plugin.board.isHider(player = (Player)snowball.getShooter())) {
                Main.plugin.glow.onProjectilve();
                snowball.remove();
                player.getInventory().remove(Material.SNOWBALL);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            if (!Main.plugin.board.isPlayer((Player)event.getEntity())) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRegainHealth(EntityRegainHealthEvent event) {
        if ((event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED || event.getRegainReason() == EntityRegainHealthEvent.RegainReason.REGEN) && event.getEntity() instanceof Player) {
            if (!Main.plugin.board.isPlayer((Player)event.getEntity())) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

