/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.world;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.world.VoidGenerator;
import org.bukkit.Bukkit;
import org.bukkit.WorldCreator;
import org.bukkit.generator.ChunkGenerator;

public class WorldLoader {
    String mapname;
    String savename;

    public WorldLoader(String mapname) {
        this.mapname = mapname;
        this.savename = "hideandseek_" + mapname;
    }

    public void unloadMap() {
        if (Bukkit.getServer().unloadWorld(Bukkit.getServer().getWorld(this.savename), false)) {
            Main.plugin.getLogger().info("Successfully unloaded " + this.savename);
        } else {
            Main.plugin.getLogger().severe("COULD NOT UNLOAD " + this.savename);
        }
    }

    public void loadMap() {
        Bukkit.getServer().createWorld(new WorldCreator(this.savename).generator((ChunkGenerator)new VoidGenerator()));
        Bukkit.getServer().getWorld(this.savename).setAutoSave(false);
    }

    public void rollback() {
        this.unloadMap();
        this.loadMap();
    }

    public String save() {
        File current = new File(Main.root + File.separator + this.mapname);
        if (current.exists()) {
            try {
                File destenation = new File(Main.root + File.separator + this.savename);
                File temp_destenation = new File(Main.root + File.separator + "temp_" + this.savename);
                this.copyFileFolder("region", true);
                this.copyFileFolder("entities", true);
                this.copyFileFolder("datapacks", false);
                File srcFile = new File(current, "level.dat");
                File destFile = new File(temp_destenation, "level.dat");
                this.copyFile(srcFile, destFile);
                if (destenation.exists()) {
                    this.deleteDirectory(destenation);
                    destenation.mkdir();
                }
                temp_destenation.renameTo(destenation);
            }
            catch (IOException e) {
                e.printStackTrace();
                return Config.errorPrefix + Localization.message("COMMAND_ERROR");
            }
            return Config.messagePrefix + Localization.message("MAPSAVE_END");
        }
        return Config.errorPrefix + Localization.message("MAPSAVE_ERROR");
    }

    private void copyFileFolder(String name, Boolean isMca) throws IOException {
        File region = new File(Main.root + File.separator + this.mapname + File.separator + name);
        File temp = new File(Main.root + File.separator + "temp_" + this.savename + File.separator + name);
        if (region.exists() && region.isDirectory()) {
            String[] files;
            if (!temp.exists() && !temp.mkdirs()) {
                throw new IOException("Couldn't create region directory!");
            }
            for (String file : files = region.list()) {
                File srcFile;
                if (isMca.booleanValue()) {
                    int minX = (int)Math.floor((double)Config.saveMinX / 32.0);
                    int minZ = (int)Math.floor((double)Config.saveMinZ / 32.0);
                    int maxX = (int)Math.floor((double)Config.saveMaxX / 32.0);
                    int maxZ = (int)Math.floor((double)Config.saveMaxZ / 32.0);
                    String[] parts = file.split(".");
                    if (parts.length > 1) {
                        Main.plugin.getLogger().info(file);
                        if (Integer.parseInt(parts[1]) < minX || Integer.parseInt(parts[1]) > maxX || Integer.parseInt(parts[2]) < minZ || Integer.parseInt(parts[2]) > maxZ) continue;
                    }
                }
                if ((srcFile = new File(region, file)).isDirectory()) {
                    this.copyFileFolder(name + File.separator + file, false);
                    continue;
                }
                File destFile = new File(temp, file);
                this.copyFile(srcFile, destFile);
            }
        }
    }

    private void copyFile(File source, File target) throws IOException {
        int length;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buffer = new byte[1024];
        while ((length = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }
}

