/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.util;

import java.io.File;
import java.util.ArrayList;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Items;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class Util {
    public static void broadcastMessage(String message) {
        for (Player player : Main.plugin.board.getPlayers()) {
            player.sendMessage(message);
        }
    }

    public static boolean isSetup() {
        if (Config.spawnPosition.getBlockX() == 0 && Config.spawnPosition.getBlockY() == 0 && Config.spawnPosition.getBlockZ() == 0) {
            return false;
        }
        if (Config.lobbyPosition.getBlockX() == 0 && Config.lobbyPosition.getBlockY() == 0 && Config.lobbyPosition.getBlockZ() == 0) {
            return false;
        }
        if (Config.exitPosition.getBlockX() == 0 && Config.exitPosition.getBlockY() == 0 && Config.exitPosition.getBlockZ() == 0) {
            return false;
        }
        File destenation = new File(Main.root + File.separator + "hideandseek_" + Config.spawnWorld);
        if (!destenation.exists()) {
            return false;
        }
        return Config.saveMinX != 0 && Config.saveMinZ != 0 && Config.saveMaxX != 0 && Config.saveMaxZ != 0;
    }

    public static void sendDelayedMessage(final String message, final int gameId, int delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Main.plugin, new Runnable(){

            @Override
            public void run() {
                if (gameId == Main.plugin.gameId) {
                    Util.broadcastMessage(message);
                }
            }
        }, (long)delay);
    }

    public static void resetPlayer(Player player) {
        player.getInventory().clear();
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        if (Main.plugin.board.isSeeker(player)) {
            if (Config.pvpEnabled) {
                for (ItemStack item : Items.SEEKER_ITEMS) {
                    player.getInventory().addItem(new ItemStack[]{item});
                }
            }
            for (PotionEffect effect : Items.SEEKER_EFFECTS) {
                player.addPotionEffect(effect);
            }
        } else if (Main.plugin.board.isHider(player)) {
            if (Config.pvpEnabled) {
                for (ItemStack item : Items.HIDER_ITEMS) {
                    player.getInventory().addItem(new ItemStack[]{item});
                }
            }
            for (PotionEffect effect : Items.HIDER_EFFECTS) {
                player.addPotionEffect(effect);
            }
            if (Config.glowEnabled) {
                ItemStack snowball = new ItemStack(Material.SNOWBALL, 1);
                ItemMeta snowballMeta = snowball.getItemMeta();
                snowballMeta.setDisplayName("Glow Powerup");
                ArrayList<String> snowballLore = new ArrayList<String>();
                snowballLore.add("Throw to make all seekers glow");
                snowballLore.add("Last 30s, all hiders can see it");
                snowballLore.add("Time stacks on multi use");
                snowballMeta.setLore(snowballLore);
                snowball.setItemMeta(snowballMeta);
                player.getInventory().addItem(new ItemStack[]{snowball});
            }
        }
    }
}

