/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Packet {
    private static ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();

    public static void playSound(Player player, Sound sound, float volume, float pitch) {
        PacketContainer packet = protocolManager.createPacket(PacketType.Play.Server.NAMED_SOUND_EFFECT);
        packet.getSoundCategories().write(0, (Object)EnumWrappers.SoundCategory.MASTER);
        packet.getSoundEffects().write(0, (Object)sound);
        packet.getIntegers().write(0, (Object)((int)(player.getLocation().getX() * 8.0)));
        packet.getIntegers().write(1, (Object)((int)(player.getLocation().getY() * 8.0)));
        packet.getIntegers().write(2, (Object)((int)(player.getLocation().getZ() * 8.0)));
        packet.getFloat().write(0, (Object)Float.valueOf(volume));
        packet.getFloat().write(1, (Object)Float.valueOf(pitch));
        try {
            protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void setGlow(Player player, Player target, boolean glowing) {
        PacketContainer packet = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getIntegers().write(0, (Object)target.getEntityId());
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(Byte.class);
        watcher.setEntity((Entity)target);
        if (glowing) {
            watcher.setObject(0, serializer, (Object)64);
        } else {
            watcher.setObject(0, serializer, (Object)0);
        }
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        try {
            protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

