/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.events;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.plugin.Plugin;

public class Worldborder {
    private final int temp;
    private int delay;
    private boolean running;

    public Worldborder(int temp) {
        this.temp = temp;
    }

    public void schedule() {
        this.delay = 60 * Config.worldborderDelay;
        this.running = false;
        this.waitBorder();
    }

    private void waitBorder() {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, () -> {
            if (this.delay == 0) {
                this.decreaceWorldborder();
            } else {
                --this.delay;
                this.waitBorder();
            }
        }, 20L);
    }

    private void decreaceWorldborder() {
        if (this.temp != Main.plugin.gameId) {
            return;
        }
        if (Config.currentWorldborderSize - 100 > 100) {
            this.running = true;
            Util.broadcastMessage(Config.worldborderPrefix + Localization.message("WORLDBORDER_DECREASING"));
            Config.currentWorldborderSize -= 100;
            World world = Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld));
            WorldBorder border = world.getWorldBorder();
            border.setSize(border.getSize() - 100.0, 30L);
            this.schedule();
        }
    }

    public static void resetWorldborder(String worldName) {
        if (Config.worldborderEnabled) {
            World world = Bukkit.getWorld((String)worldName);
            WorldBorder border = world.getWorldBorder();
            border.setSize((double)Config.worldborderSize);
            border.setCenter(Config.worldborderPosition.getX(), Config.worldborderPosition.getZ());
            Config.currentWorldborderSize = Config.worldborderSize;
        } else {
            World world = Bukkit.getWorld((String)worldName);
            WorldBorder border = world.getWorldBorder();
            border.setSize(3.0E7);
            border.setCenter(0.0, 0.0);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.running;
    }
}

