/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.events;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.util.Packet;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Glow {
    private final int temp;
    private int glowTime;
    private boolean running;

    public Glow(int temp) {
        this.temp = temp;
        this.glowTime = 0;
    }

    public void onProjectilve() {
        this.glowTime = Config.glowStackable ? (this.glowTime += Config.glowLength) : Config.glowLength;
        if (!this.running) {
            this.startGlow();
        }
    }

    private void startGlow() {
        this.running = true;
        for (Player hider : Main.plugin.board.getHiders()) {
            for (Player seeker : Main.plugin.board.getSeekers()) {
                Packet.setGlow(hider, seeker, true);
            }
        }
        this.waitGlow();
    }

    private void waitGlow() {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, () -> {
            if (this.temp != Main.plugin.gameId) {
                return;
            }
            --this.glowTime;
            this.glowTime = Math.max(this.glowTime, 0);
            if (this.glowTime == 0) {
                this.stopGlow();
            } else {
                this.waitGlow();
            }
        }, 20L);
    }

    private void stopGlow() {
        this.running = false;
        for (Player hider : Main.plugin.board.getHiders()) {
            for (Player seeker : Main.plugin.board.getSeekers()) {
                Packet.setGlow(hider, seeker, false);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

