/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.ConfigManager;
import net.tylermurphy.hideAndSeek.configuration.LocalizationString;

public class Localization {
    public static final Map<String, LocalizationString> LOCAL = new HashMap<String, LocalizationString>();
    private static String[][] CHANGES = new String[][]{{"WORLDBORDER_DECREASING"}};

    public static void loadLocalization() {
        String SELECTED_LOCAL;
        ConfigManager manager = new ConfigManager("localization.yml", "lang" + File.separator + "localization_" + Config.local + ".yml");
        int PLUGIN_VERSION = 2;
        int VERSION = manager.getInt("version");
        if (VERSION < PLUGIN_VERSION) {
            for (int i = VERSION; i < PLUGIN_VERSION; ++i) {
                String[] changeList;
                if (i < 1) continue;
                for (String change : changeList = CHANGES[i - 1]) {
                    manager.reset("Localization." + change);
                }
            }
            manager.reset("version");
        }
        if ((SELECTED_LOCAL = manager.getString("type")) == null) {
            manager.reset("type");
        } else if (!SELECTED_LOCAL.equals(Config.local)) {
            manager.resetFile("lang" + File.separator + "localization_" + Config.local + ".yml");
        }
        manager.saveConfig();
        for (String key : manager.getConfigurationSection("Localization").getKeys(false)) {
            LOCAL.put(key, new LocalizationString(ChatColor.translateAlternateColorCodes((char)'&', (String)manager.getString("Localization." + key))));
        }
    }

    public static LocalizationString message(String key) {
        LocalizationString temp = LOCAL.get(key);
        if (temp == null) {
            return new LocalizationString(ChatColor.RED + "" + ChatColor.ITALIC + key + "is not found in localization.yml. This is a plugin issue, please report it.");
        }
        return new LocalizationString(temp.toString());
    }
}

